C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------
c     Program Changes:

c      - original written: May 1, 1996

c     Program Description:

c     Replacement for old SIS SLVR program to generate various output velocity
c     types (or density) based on either input TDFN (2D or 3D) functions, etc,
c     and optional horizon control files (either xsd picks for 2D or landmark
c     horzn files for 3D).

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsampo, nsi, nsio, ntrc, ntrco, nrec, nreco
      integer     iform, iend
      integer     luvel , luout, lbytes, nbytes, lbyout, obytes
      integer     argis, lupik
      integer     limin, limax, dimin, dimax

      real        tri ( SZLNHD )

      real        fmscl, mfscl
      real        DX, DY
      REAL*8      XX, XY, YX, YY, XXT, XYT, YXT, YYT
      REAL*8      DE, DF, E, F, XYYXXY

      character   otap*255, vtap*255, htap*255, name*4

      logical     verbos, debug, f2m, m2f, XYs
      logical     D3, tdfn, geco, g2d, digi, usp, xsd, lmk

c Program Specific _ dynamic memory variables

      integer ierr1, ierr2, ierr3, ierr4, ierr5, ierr6, ierr7, ierr8
      integer ierr9, ierr0, ierra, ierrb, ierrc, ierrd, ierre, ierrf
      integer ierrg, ierrh, ierri, ierrj, ierrk, ierrl, ierrm
      integer ierrn, ierro, ierrp, iabort

      real    times, velocities, horizons, work1, work2, work3
      real    tim1, timt, tim2, thor1, thort, thor2
      real    vel1, vel2, vel3, vhor1, vhort, vhor2, zz
      integer iwrk, livec, divec, horvec, fmap
      integer ineighb, jneighb, iz

      pointer (wkadrv  , velocities(1000000))
      pointer (wkadrt  , times     (1000000))
      pointer (wkadrt1 , tim1      (1000000))
      pointer (wkadrtt , timt      (1000000))
      pointer (wkadrt2 , tim2      (1000000))
      pointer (wkadrh1 , thor1     (1000000))
      pointer (wkadrht , thort     (1000000))
      pointer (wkadrh2 , thor2     (1000000))
      pointer (wkadrvh1, vhor1     (1000000))
      pointer (wkadrvht, vhort     (1000000))
      pointer (wkadrvh2, vhor2     (1000000))
      pointer (wkadrh  , horizons  (1000000))
      pointer (wkadrw  , horvec    (1000000))
      pointer (wkadrl  , livec     (1000000))
      pointer (wkadrd  , divec     (1000000))
      pointer (wkadri  , iwrk      (1000000))
      pointer (wkadrk1 , work1     (1000000))
      pointer (wkadrk2 , work2     (1000000))
      pointer (wkadrk3 , work3     (1000000))
      pointer (wkadrv1 , vel1      (1000000))
      pointer (wkadrv2 , vel2      (1000000))
      pointer (wkadrv3 , vel3      (1000000))
      pointer (wkadrfm , fmap      (1000000))
      pointer (wkadrinb, ineighb   (1000000))
      pointer (wkadrjnb, jneighb   (1000000))
      pointer (wkadriz , iz        (1000000))
      pointer (wkadrzz , zz        (1000000))

c Program Specific _ static memory variables

      common /hdrs/
     1        ifmt_RecNum,l_RecNum,ln_RecNum,
     2        ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     3        ifmt_StaCor,l_StaCor,ln_StaCor,
     4        ifmt_DphInd,l_DphInd,ln_DphInd,
     5        ifmt_LinInd,l_LinInd,ln_LinInd,
     5        ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,
     5        ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY

c Initialize variables

      data iabort/1/
      data name/'SLVR'/

      fmscl = 0.30480
      mfscl = 3.28084

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( otap, vtap, htap, iend, ntrco, nreco, nsio,
     1             limin, limax, dimin, dimax, f2m, m2f,
     2             xsd, lmk, tdfn, geco, g2d, digi, usp, D3,
     3             luvel, lupik, name,debug,lu_debug, XYs, irad,
     4             IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4, DY, DX,
     5             verbos)

c----
c  XY feet -> m or m-> feet scaler
c----
          if     ( f2m ) then
             xyscl = fmscl
          elseif ( m2f ) then
             xyscl = mfscl
          else
             xyscl = 1.0
          endif

c-----
C build LI/DI coordinates if we are in 3D mode and if we are using
c XYs rather than LI/DI (here the limin, etc can be used as limiters
c on the survey extent)
c-----
      IF (D3 .AND. XYs) THEN

         CALL XFMI  (IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1               IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT)

         if (limax .eq. 0) then
             maxli = NX
         else
             maxli = limax
         endif
         if (limin .eq. 0) then
             minli = 1
         else
             minli = limin
         endif
         if (dimax .eq. 0) then
             maxdi = NY
         else
             maxdi = dimax
         endif
         if (dimin .eq. 0) then
             mindi = 1
         else
             mindi = dimin
         endif
 
         DE = DBLE(FLOAT(IX1)) * XXT + DBLE(FLOAT(IY1)) * XYT
         DF = DBLE(FLOAT(IX1)) * YXT + DBLE(FLOAT(IY1)) * YYT
         XYYXXY =  XYT * YXT - XXT * YYT
         if (XYYXXY .eq. 0.) then
          write(LERR,*)' '
          write(LERR,*)'FATAL ERROR in slvr 3D XY option:'
          write(LERR,*)'Attempt to use survey coords to fill in bin'
          write(LERR,*)'centers failed due to coord transform'
          write(LERR,*)'singularity (bad coord choice most likely)'
          call ccexit (666)
         endif

c-----
C build LI/DI coordinates if we are in 3D mode and if we are using
c LI/DI rather than XYs
c-----
      ELSEIF (D3 .AND. .not. XYs) THEN

         maxli = limax
         minli = limin
         maxdi = dimax
         mindi = dimin

      ENDIF

c open input and output files


      call getln(luout, otap,'w', 1)

c  for USP velocity: read input line header and save certain parameters

      if ( usp ) then

         call getln(luvel , vtap,'r', 1)
         call rtape(luvel,itr,lbytes)
         if(lbytes.eq.0)then
            write(LER,*)'SLVR: no line header on input dataset',vtap
            write(LER,*)'FATAL'
            stop
         endif

         call saver(itr, 'NumSmp', nsamp, LINHED)
         call saver(itr, 'SmpInt', nsi  , LINHED)
         call saver(itr, 'NumTrc', ntrc , LINHED)
         call saver(itr, 'NumRec', nrec , LINHED)
         call saver(itr, 'Format', iform, LINHED)
         call hlhprt (itr, lbytes, name, 4, LERR)
         nsio = nsi
         si   = nsi

      endif

c define pointers to header words required by your routine

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)


c====
c   choose USP of flat file velocity:
c   open and scan velocity function file for max number of elements
c   per function and max number of functions
c====
       IF (.not. usp) THEN
          call velinit (luvel, tdfn, geco, g2d, digi, D3,
     1                  maxnum, maxfunc, name, IX1, IY1, DX, DY,
     2                  XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     3                  minli, maxli, mindi, maxdi, NX, NY,
     4                  XYs)

       ELSE

       ENDIF

c====
c   open horizon file and scan for number of horizons and
c   the number of points in each horizon
c   For the 2D case we support standard xsd pick files; for 3D
c   we support landmark-style horizon files
c====
       IF (.not. D3) THEN

          call hint2d (lupik, nhor, npick, nrc, ntr, nsamp,
     1                 unitr, unitt, units, offr, offt, name)
c----
c   take the global header info extracted from the pick file and use
c   them for the output - remember our output velocity data set will
c   be the same 'size' as the picked stack section
c----
          ndi    = nrc * ntr
          nli    = 1
c         nreco  = nrc
          nreco  = dimax - dimin + 1
          ntrco  = 1
          nsampo = nsamp
          nsio   = nint (units)
          si     = units

       ELSE

c----
c   The horizon files must all be packed into one file with each horzn
c   separated by a null or blank line. The size of the output volume
c   will be determined by horz file nli & ndi and the cmd line input nsampo
c----
          call hint3d (lupik, nhor, minli, maxli, mindi, maxdi,
     1                 nli, ndi, xsd, lmk, name, XYs, IX1, IY1,
     2                 NX, NY, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     3                 DX, DY)

          limin = minli
          limax = maxli
          dimin = mindi
          dimax = maxdi
          nreco  = nli
          ntrco  = ndi

          if (nsio .eq. 0) then
             write(LERR,*)'FATAL ERROR in ',name
             write(LERR,*)'Must supply sample interval -si[]'
             write(LER ,*)'FATAL ERROR in ',name
             write(LER ,*)'Must supply sample interval -si[]'
             stop
          else
             si = nsio
          endif
          nsampo = (iend + nsio) / nsio
          nsamp  = nsampo

       ENDIF

c dynamic memory allocation:  

      itemv = maxnum * maxfunc
      itemh = nhor * nli * ndi
      itemt = nsampo
      itemu = 4 * nsampo
      if (D3) then
         items = maxnum * maxfunc
      else
         items = max (maxnum, nhor + 2)
      endif
      itemm = nli * ndi
      itemw = ndi
      itemi = max (ndi,nli)
      iteml = maxfunc
      itemd = maxfunc
      itemk = max (ndi,nli,nsampo)
      call galloc (wkadrv  , itemv * SZSMPD, ierr1, iabort)
      call galloc (wkadrt  , itemv * SZSMPD, ierr2, iabort)
      call galloc (wkadrt1 , itemt * SZSMPD, ierr3, iabort)
      call galloc (wkadrtt , itemt * SZSMPD, ierr4, iabort)
      call galloc (wkadrt2 , itemt * SZSMPD, ierr5, iabort)
      call galloc (wkadrh  , itemh * SZSMPD, ierr6, iabort)
      call galloc (wkadrw  , itemw * SZSMPD, ierr7, iabort)
      call galloc (wkadrl  , iteml * SZSMPD, ierr8, iabort)
      call galloc (wkadrd  , itemd * SZSMPD, ierr9, iabort)
      call galloc (wkadri  , itemk * SZSMPD, ierr0, iabort)
      call galloc (wkadrk1 , itemk * SZSMPD, ierra, iabort)
      call galloc (wkadrk2 , itemk * SZSMPD, ierrb, iabort)
      call galloc (wkadrk3 , itemk * SZSMPD, ierrc, iabort)
      call galloc (wkadrv1 , itemk * SZSMPD, ierrd, iabort)
      call galloc (wkadrv2 , itemk * SZSMPD, ierre, iabort)
      call galloc (wkadrv3 , itemk * SZSMPD, ierrf, iabort)
      call galloc (wkadrh1 , items * SZSMPD, ierrg, iabort)
      call galloc (wkadrht , items * SZSMPD, ierrh, iabort)
      call galloc (wkadrh2 , items * SZSMPD, ierri, iabort)
      call galloc (wkadrvh1, items * SZSMPD, ierrj, iabort)
      call galloc (wkadrvht, items * SZSMPD, ierrk, iabort)
      call galloc (wkadrvh2, items * SZSMPD, ierrl, iabort)
      call galloc (wkadrfm , itemm * SZSMPD, ierrm, iabort)
      call galloc (wkadrinb, itemi * SZSMPD, ierrn, iabort)
      call galloc (wkadrjnb, itemi * SZSMPD, ierro, iabort)
      call galloc (wkadriz , itemt * SZSMPD, ierrp, iabort)
      call galloc (wkadrzz , itemu * SZSMPD, ierrq, iabort)

      if ( ierr1.ne.0 .OR. ierr2.ne.0 .OR. ierr3.ne.0 .OR.
     1     ierr4.ne.0 .OR. ierr5.ne.0 .OR. ierr6.ne.0 .OR.
     2     ierr7.ne.0 .OR. ierr8.ne.0 .OR. ierr9.ne.0 .OR.
     3     ierr0.ne.0 .OR. ierra.ne.0 .OR. ierrb.ne.0 .OR.
     4     ierrc.ne.0 .OR. ierrd.ne.0 .OR. ierre.ne.0 .OR.
     5     ierrf.ne.0 .OR. ierrg.ne.0 .OR. ierrh.ne.0 .OR.
     6     ierri.ne.0 .OR. ierrj.ne.0 .OR. ierrk.ne.0 .OR.
     7     ierrl.ne.0 .OR. ierrm.ne.0 .OR. ierrn.ne.0 .OR.
     8     ierro.ne.0 .OR. ierrp.ne.0 .OR. ierrq.ne.0) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemv * SZSMPD, '  bytes'
         write(LERR,*) itemv * SZSMPD, '  bytes'
         write(LERR,*) itemt * SZSMPD, '  bytes'
         write(LERR,*) itemt * SZSMPD, '  bytes'
         write(LERR,*) itemt * SZSMPD, '  bytes'
         write(LERR,*) itemh * SZSMPD, '  bytes'
         write(LERR,*) itemw * SZSMPD, '  bytes'
         write(LERR,*) iteml * SZSMPD, '  bytes'
         write(LERR,*) itemd * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) items * SZSMPD, '  bytes'
         write(LERR,*) items * SZSMPD, '  bytes'
         write(LERR,*) items * SZSMPD, '  bytes'
         write(LERR,*) items * SZSMPD, '  bytes'
         write(LERR,*) items * SZSMPD, '  bytes'
         write(LERR,*) items * SZSMPD, '  bytes'
         write(LERR,*) itemm * SZSMPD, '  bytes'
         write(LERR,*) itemi * SZSMPD, '  bytes'
         write(LERR,*) itemi * SZSMPD, '  bytes'
         write(LERR,*) itemt * SZSMPD, '  bytes'
         write(LERR,*) itemu * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER ,*) itemv * SZSMPD, '  bytes'
         write(LER ,*) itemv * SZSMPD, '  bytes'
         write(LER ,*) itemt * SZSMPD, '  bytes'
         write(LER ,*) itemt * SZSMPD, '  bytes'
         write(LER ,*) itemt * SZSMPD, '  bytes'
         write(LER ,*) itemh * SZSMPD, '  bytes'
         write(LER ,*) itemw * SZSMPD, '  bytes'
         write(LER ,*) iteml * SZSMPD, '  bytes'
         write(LER ,*) itemd * SZSMPD, '  bytes'
         write(LER ,*) itemk * SZSMPD, '  bytes'
         write(LER ,*) itemk * SZSMPD, '  bytes'
         write(LER ,*) itemk * SZSMPD, '  bytes'
         write(LER ,*) itemk * SZSMPD, '  bytes'
         write(LER ,*) itemk * SZSMPD, '  bytes'
         write(LER ,*) itemk * SZSMPD, '  bytes'
         write(LER ,*) itemk * SZSMPD, '  bytes'
         write(LER ,*) items * SZSMPD, '  bytes'
         write(LER ,*) items * SZSMPD, '  bytes'
         write(LER ,*) items * SZSMPD, '  bytes'
         write(LER ,*) items * SZSMPD, '  bytes'
         write(LER ,*) items * SZSMPD, '  bytes'
         write(LER ,*) items * SZSMPD, '  bytes'
         write(LER ,*) itemm * SZSMPD, '  bytes'
         write(LER ,*) itemi * SZSMPD, '  bytes'
         write(LER ,*) itemi * SZSMPD, '  bytes'
         write(LER ,*) itemt * SZSMPD, '  bytes'
         write(LER ,*) itemu * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemv * SZSMPD, '  bytes'
         write(LERR,*) itemv * SZSMPD, '  bytes'
         write(LERR,*) itemt * SZSMPD, '  bytes'
         write(LERR,*) itemt * SZSMPD, '  bytes'
         write(LERR,*) itemt * SZSMPD, '  bytes'
         write(LERR,*) itemh * SZSMPD, '  bytes'
         write(LERR,*) itemw * SZSMPD, '  bytes'
         write(LERR,*) iteml * SZSMPD, '  bytes'
         write(LERR,*) itemd * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) items * SZSMPD, '  bytes'
         write(LERR,*) items * SZSMPD, '  bytes'
         write(LERR,*) items * SZSMPD, '  bytes'
         write(LERR,*) items * SZSMPD, '  bytes'
         write(LERR,*) items * SZSMPD, '  bytes'
         write(LERR,*) items * SZSMPD, '  bytes'
         write(LERR,*) itemm * SZSMPD, '  bytes'
         write(LERR,*) itemi * SZSMPD, '  bytes'
         write(LERR,*) itemi * SZSMPD, '  bytes'
         write(LERR,*) itemt * SZSMPD, '  bytes'
         write(LERR,*) itemu * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

      itot = 2 * itemv * SZSMPD + 4 * itemt * SZSMPD +
     1       itemh * SZSMPD + itemw * SZSMPD + iteml * SZSMPD +
     2       itemd * SZSMPD + 2 * itemi * SZSMPD + 7 * itemk * SZSMPD +
     3       6 * items * SZSMPD + itemm * SZSMPD + itemu * SZSMPD

      write(LERR,*)' '
      write(LERR,*)'Total memory used= ',itot,'  bytes'
      write(LERR,*)' '
c====
c   Read all horizon picks for either 2D or 3D
c====
      IF (.not. D3) THEN

         call xsdhor (lupik, nhor, ndi, horizons, horvec, work1, work2,
     1                work3, unitr, unitt, offr, offt, nrc, ntr, iwrk,
     2                vel3, itemk, verbos, name, itmax)

      ELSE

         call lmrd  (lupik, nli, ndi, nhor, minli, maxli, mindi, maxdi,
     1               horizons, SZSMPD, si, debug, IX1, IY1, DX, DY,
     2               XX, XY, YX, YY, XXT, XYT, YXT, YYT, xyscl, verbos,
     3               lu_debug, name, livec, divec, work1, itemk, XYs,
     4               itmax)

      ENDIF

       if (itmax .gt. iend) then
          write(LERR,*)' '
          write(LERR,*)'FATAL ERROR in slvr:'
          write(LERR,*)'User end time ',iend,' < max horz time ',itmax
          write(LERR,*)'Increase -e[] to value larger than ',itmax
          write(LER ,*)' '
          write(LER ,*)'FATAL ERROR in slvr:'
          write(LER ,*)'User end time ',iend,' < max horz time ',itmax
          write(LER ,*)'Increase -e[] to value larger than ',itmax
          stop
       endif

c====
c   We now have complete horizons full interpolated to the edges of the
c   survey (and in the case of 2D we also have a vector of fully
c   interpolated record numbers)
c====

c====
c   Read all velocity functions for either 2D or 3D
c====
      IF (.not. usp) THEN

          call rdvels (luvel, maxnum, maxfunc, velocities, times,
     1                livec, divec, verbos, si, nhor, ndi, nli,
     2                fmap, D3, name, IX1, IY1, DX, DY, NX, NY,
     3                XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     4                minli, maxli, mindi, maxdi, geco, tdfn, digi,
     5                XYs, work1, work2, work3, iwrk, nsampo,
     6                itmax)
 
      ENDIF

c verbose output of all pertinent information before processing begins

      call verbal( vtap, otap, htap, nsampo, nsio, ntrco, nreco, 
     1             iend, nhor, D3, nli, ndi, horizons, horvec,
     2             irad)


c=============
c modify line header to reflect actual record configuration output
c NOTE: in this case the sample limits ist and iend are used to
c       limit processing only.   All data samples are actually passed.
 
      call savew(itr, 'NumRec', nreco  , LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)
      call savew(itr, 'MnLnIn', limin  , LINHED)
      call savew(itr, 'MxLnIn', limax  , LINHED)
      call savew(itr, 'MnDpIn', dimin  , LINHED)
      call savew(itr, 'MxDpIn', dimax  , LINHED)

c----
c   Build line header for output velocity data set
c----

      if ( .not. usp ) then
 
c must build historical line header from scratch if not USP input data
 
         lbytes = HSTOFF
         nbytes = 2 * SZHFWD
         call savew(itr, 'Format', 1      , LINHED)
         call savew(itr, 'SmpInt', nsio   , LINHED)
         call savew(itr, 'NumSmp', nsampo , LINHED)
         call savew( itr, 'HlhEnt',  0   , LINHED)
         call savew( itr, 'HlhByt', nbytes , LINHED)
      endif
 
c number output bytes
 
      obytes = SZTRHD + SZSMPD * nsampo
 
c save out hlh and line header
 
      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c BEGIN PROCESSING 


      IF ( D3 ) THEN

         call vel3d  (maxnum, maxfunc, nhor, nli, ndi, limin, limax,
     1                divec, livec, times, velocities, horizons,
     2                SZSMPD, ITHWP1, itr, tri, nsamp, si, itemi,
     3                dimin, dimax, work1, work2, work3, itemk,
     4                obytes, luout, name, tim1, timt, tim2,
     5                thor1, thort, thor2, vhor1, vhort, vhor2,
     6                vel1, vel2, vel3, fmap, ineighb, jneighb,
     7                iz, zz, irad, verbos, XYs, IX1, IY1, DX, DY,
     8                XX, XY, YX, YY, XXT, XYT, YXT, YYT, DE, DF,
     9                E, F, XYYXXY)

      ELSE

         call velgen (JJ, maxnum, maxfunc, nhor, ndi, divec,
     1                horvec, times, velocities, horizons,
     2                SZSMPD, ITHWP1, itr, tri, nsamp, si,
     3                dimin, dimax, work1, work2, work3, itemk,
     4                obytes, luout, name, tim1, timt, tim2,
     5                thor1, thort, thor2, vhor1, vhort, vhor2,
     6                vel1, vel2, vel3, iz, zz)

      ENDIF


c           call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
c    :           RecNum, TRACEHEADER )

c           call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
c    :           StaCor, TRACEHEADER )


c              call vmov ( tri, 1, itr(ITHWP1), 1, nsamp )

c           call wrtape (luout, itr, obytes)

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'slvr: Normal Termination'
      write(LER,*)'slvr: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'slvr: ABNORMAL Termination'
      write(LER,*)'slvr: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for slvr: seislith velocity'
      write(LER,*)' or density traces with optional horizon control'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-v[]   -- input velocity functions'
      write(LER,*)'-P[]   -- input horizons file'
      write(LER,*)'-O[]   -- output data set                (stdout)'
c     write(LER,*)'-it[]  -- input function type                 (0)'
c     write(LER,*)'          0=RMS; 1=Interval; 2=Average; 3=Time'
c     write(LER,*)'          Depth Pairs; 4=Well Log Interval Vel.;'
c     write(LER,*)'          5=Well Log Bulk Density'
c     write(LER,*)'-ot[]  -- output function type                (0)'
      write(LER,*)'-si[]  -- output sample interval           (none)'
      write(LER,*)'-e[]   -- length of trace (time)           (none)'
c     write(LER,*)'-nt[]  -- number trace/record to output    (none)'
c     write(LER,*)'-nr[]  -- number records to output         (none)'
      write(LER,*) ' '
      write(LER,*)'-dimin[] -- minimum DI (2D & 3D)           (none)'
      write(LER,*)'-dimax[] -- maximum DI (2D & 3D)           (none)'
      write(LER,*) '3D Options:'
      write(LER,*)'-limin[] -- minimum LI (3D)                (none)'
      write(LER,*)'-limax[] -- maximum LI (3D)                (none)'
      write(LER,*)'-tol[tol]-- search radius (ft,m)           (none)'
      write(LER,*)
     :' -x1[x1]      (def = none)  : X-coord of Corner 1 (3D option)'
      write(LER,*)
     :' -y1[y1]      (def = none)  : Y-coord of Corner 1 (3D option)'
      write(LER,*)
     :' -x2[x2]      (def = none)  : X-coord of Corner 2 (3D option)'
      write(LER,*)
     :' -y2[y2]      (def = none)  : Y-coord of Corner 2 (3D option)'
      write(LER,*)
     :' -x3[x3]      (def = none)  : X-coord of Corner 3 (3D option)'
      write(LER,*)
     :' -y3[y3]      (def = none)  : Y-coord of Corner 3 (3D option)'
      write(LER,*)
     :' -x4[x4]      (def = none)  : X-coord of Corner 4 (3D option)'
      write(LER,*)
     :' -y4[y4]      (def = none)  : Y-coord of Corner 4 (3D option)'
      write(LER,*)
     :' -ildm[ildm]  (def = none)  : spacing along 1-2 direction (dy)'
      write(LER,*)
     :' -cldm[cldm]  (def = none)  : spacing along 2-3 direction (dx)'

      write(LER,*) ' '
      write(LER,*)'-xsd   -- horizons are xsd pick file format (2D)'
      write(LER,*)'-lmk   -- horizons are landmark-type hozns  (3D)'
      write(LER,*)'-tdfn  -- velocities are TDFN (2D or 3D)'
      write(LER,*)'-usp   -- velocities are USP (2D or 3D)'
      write(LER,*)'-geco  -- velocities are GECO-type format'
c     write(LER,*)'-g2d   -- velocities are GECO-type format (2D)'
      write(LER,*)'-digi  -- velocities are DIGICON-type format'
      write(LER,*)'-D3    -- 3D mode; else 2D assumed'
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'  slvr [ -v[] -P[] ] -O[] -si[] -e[] [ -D3 ]'
      write(LER,*)'         -dimin[] -dimax[] [ tol[] -limin[] -limax[]'
      write(LER,*)'         -x1[] -y1[] -x2[] -y2[] -x3[] -y3[] -x4[]'
      write(LER,*)'         -x4[] -y4[] -ildm[] -icdm[] ]'
      write(LER,*)'       [ -xsd -lmk ] [ -tdfn -usp -geco -digi ]'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( otap, vtap, htap, iend, ntrco, nreco, nsio,
     1                   limin, limax, dimin, dimax, f2m, m2f,
     2                   xsd, lmk, tdfn, geco, g2d, digi, usp, D3,
     3                   luvel, lupik, name,debug,lu_debug, XYs, irad,
     4                   IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4, DY, DX,
     5                   verbos)

#include <f77/iounit.h>

      integer    iend, nsio, ntrco, nreco, argis
      integer    limin, limax, dimin, dimax
      integer    luvel, lupik
      integer    IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4
      integer    irad

      character  vtap*(*), otap*(*), htap*(*), name*(*)
      character  dtap*13

      logical    D3, tdfn, geco, g2d, digi, usp, xsd, lmk
      logical    verbos, debug, f2m, m2f, XYs


      dtap = 'SLVR_HORIZONS'


      tdfn   = (argis('-tdfn') .gt. 0)
      geco   = (argis('-geco') .gt. 0)
      digi   = (argis('-digi') .gt. 0)
      g2d    = (argis('-g2d') .gt. 0)

      if (.not.geco .AND. .not.g2d .AND. .not.digi) then
         tdfn = .true.
      endif

      usp    = (argis('-usp') .gt. 0)
      lmk    = (argis('-lmk') .gt. 0)
      xsd    = (argis('-xsd') .gt. 0)
      D3     = (argis('-D3') .gt. 0)
      debug  = (argis('-debug') .gt. 0)
      verbos = (argis('-V') .gt. 0)
      f2m  = ( argis( '-f2m' ) .gt. 0 )
      m2f  = ( argis( '-m2f' ) .gt. 0 )

           call argi4 ( '-limin', limin, 1, 1 )
           call argi4 ( '-limax', limax, 0, 0 )
           call argi4 ( '-dimin', dimin, 1, 1 )
           call argi4 ( '-dimax', dimax, 0, 0 )
           call argi4 ('-x1', ix1, 0 , 0 )
           call argi4 ('-y1', iy1, 0 , 0 )
           call argi4 ('-x2', ix2, 0 , 0 )
           call argi4 ('-y2', iy2, 0 , 0 )
           call argi4 ('-x3', ix3, 0 , 0 )
           call argi4 ('-y3', iy3, 0 , 0 )
           call argi4 ('-x4', ix4, 0 , 0 )
           call argi4 ('-y4', iy4, 0 , 0 )
           call argr4 ('-cldm', dx, 0., 0.)
           call argr4 ('-ildm', dy, 0., 0.)
           if (dx .eq. 0.) call argr4 ('-cellx',dx,0.,0.)
           if (dy .eq. 0.) call argr4 ('-celly',dy,0.,0.)
           call argr4 ('-tol', rad, 0., 0.)

           XYs = .false.
           IF ( D3 ) THEN
             if (dx .eq. 0. .OR. dy .eq. 0.) then
                write(LERR,*)' '
                write(LERR,*)'Fatal Error in ',name
                write(LERR,*)'For 3D option must enter -cldm[] -ildm[]'
                write(LER ,*)' '
                write(LER ,*)'Fatal Error in ',name
                write(LER ,*)'For 3D option must enter -cldm[] -ildm[]'
                stop
             endif
             radius = sqrt ( .5 *(dx*dx + dy*dy) )
             if (rad .eq. 0.) then
                write(LERR,*)' '
                write(LERR,*)'Warning in ',name
                write(LERR,*)'3D option: search radius cannot be zero'
                write(LERR,*)'Will reset to 10x cell dimension: ',
     1                        10 * radius
                rad = 5 * radius
             endif
             irad = nint ( rad / radius )
             if (irad .le. 1) then
                 write(LERR,*)' '
                 write(LERR,*)'Fatal Error in ',name
                 write(LERR,*)'Search radius must be larger than ',
     1           2*radius
                 write(LER ,*)' '
                 write(LER ,*)'Fatal Error in ',name
                 write(LER ,*)'Search radius must be larger than ',
     1           2*radius
                 stop
             endif

             if (dimin .lt. 1) then
                 write(LERR,*)'WARNING from ',name
                 write(LERR,*)'-dimin[] must be > 0; setting to 1'
                 dimin = 1
             endif
             if (dimin .lt. 1) then
                 write(LERR,*)'WARNING from ',name
                 write(LERR,*)'-limin[] must be > 0; setting to 1'
                 limin = 1
             endif
                

           IF (dx .ne. 0.0 .AND. dy .ne. 0.0) THEN

             if (ix1.ne.0 .OR. iy1.ne.0 .OR. ix2.ne.0 .OR. iy2.ne.0
     1            .OR.
     2           ix3.ne.0 .OR. iy3.ne.0 .OR. ix4.ne.0 .OR. iy4.ne.0
     3           ) then
                XYs = .true.
             endif
             if ( XYs ) then
             if (ix1.eq.0 .AND. iy1.eq.0 .AND. ix2.eq.0 .AND. iy2.eq.0
     1            .AND.
     2           ix3.eq.0 .AND. iy3.eq.0 .AND. ix4.eq.0 .AND. iy4.eq.0
     3           ) then
                write(LERR,*)' '
                write(LERR,*)'Fatal Error in ',name
                write(LERR,*)'Must enter 4 corners of survey: use -x1[]'
                write(LERR,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
                write(LER ,*)' '
                write(LER ,*)'Fatal Error in ',name
                write(LER ,*)'Must enter 4 corners of survey: use -x1[]'
                write(LER ,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
                stop
             endif
             endif
           ENDIF

           IF (.not. XYs) THEN
           IF (limin.eq.0 .AND. limax.eq.0 .AND. 
     1         dimin.eq.0 .AND. dimax.eq.0)  THEN

                write(LERR,*)' '
                write(LERR,*)'Fatal Error in ',name
                write(LERR,*)'Must enter 4 corners of survey: use'
                write(LERR,*)'-limax[] -limin[] -dimax[] -dimin[]'
                write(LER ,*)' '
                write(LER ,*)'Fatal Error in ',name
                write(LER ,*)'Must enter 4 corners of survey: use'
                write(LER ,*)'-limax[] -limin[] -dimax[] -dimin[]'
                stop

           ENDIF
           ENDIF


           ENDIF

           call argi4 ( '-nt', ntrco, 0, 0 )
           call argi4 ( '-nr', nreco, 0, 0 )
           call argi4 ( '-si', nsio , 0, 0 )
           call argi4 ( '-e', iend, 0, 0 )

           call argstr ( '-v', vtap, ' ', ' ' ) 

           call argstr ( '-P', htap, ' ', ' ' ) 

           call argstr ( '-O', otap, ' ', ' ' ) 

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

      if ( .not. usp ) then
         call alloclun ( luvel )
         open (unit=luvel,file=vtap,status='old',iostat=ierr)
 
         if (ierr .ne. 0) then
             write(LERR,*)'FATAL ERROR in ',name,':'
             write(LERR,*)'Could not open input velocity file ',
     1                     vtap
             write(LERR,*)'Check directory permissions'
             write(LER ,*)'FATAL ERROR in ',name,':'
             write(LER ,*)'Could not open input velocity file ',
     1                     vtap
             write(LER ,*)'Check directory permissions'
             stop
         endif
      endif

      call alloclun ( lupik )
      open (unit=lupik,file=htap,status='old',iostat=ierr)
 
      if (ierr .ne. 0) then
          write(LERR,*)'FATAL ERROR in ',name,':'
          write(LERR,*)'Could not open input horizon pick file ',
     1                  htap
          write(LERR,*)'Check directory permissions'
          write(LER ,*)'FATAL ERROR in ',name,':'
          write(LER ,*)'Could not open input horizon pick file ',
     1                  htap
          write(LER ,*)'Check directory permissions'
          stop
      endif

      if ( debug ) then
         call alloclun ( lu_debug )
         open (unit=lu_debug,file=dtap,status='unknown',iostat=ierr)
 
         if (ierr .ne. 0) then
             write(LERR,*)'FATAL ERROR in ',name,':'
             write(LERR,*)'Could not open output horizon file ',
     1                     dtap
             write(LERR,*)'Check directory permissions'
             write(LER ,*)'FATAL ERROR in ',name,':'
             write(LER ,*)'Could not open output horizon file ',
     1                     dtap
             write(LER ,*)'Check directory permissions'
             stop
         endif
      endif
           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( vtap, otap, htap, nsamp, nsi, ntrc, nrec,
     1                    iend, nhor, D3, nli, ndi, horizon, horvec,
     2                    irad)

#include <f77/iounit.h>

      real       horizon (ndi, nli, nhor)
      integer    horvec (*), nhor, nli, ndi, irad
      integer    nsamp, ntrc, nrec, iend, nsi
      character  vtap*(*), otap*(*), htap*(*)
      logical    D3

      write(LERR,*)' '
      write(LERR,*)' Job & Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input velocity data set name =  ', vtap
      write(LERR,*) ' input horizon pick file name =  ', htap
      write(LERR,*) ' output velocity data set name=  ', otap
      write(LERR,*) ' output samples per trace     =  ', nsamp
      write(LERR,*) ' output traces per record     =  ', ntrc
      write(LERR,*) ' output number of records     =  ', nrec
      write(LERR,*) ' output sample interval       =  ', nsi
      write(LERR,*) ' output trace length (time)   =  ', iend
      write(LERR,*)' '
      if ( D3 ) then
      write(LERR,*) ' Number of LIs                =  ', nli
      write(LERR,*) ' Number of DIs                =  ', ndi
      write(LERR,*) ' Number of horizons           =  ', nhor
      write(LERR,*) ' Search radius (cell units)   =  ', irad
      else
      write(LERR,*) ' Number of DIs                =  ', ndi
      write(LERR,*) ' Number of horizons           =  ', nhor
      endif
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





