C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c---
c  routine to build a properly sampled velocity trace at a spatial location
c  between 2 control points and between an upper and lower horizon boundary.
c  Kh is the icurrent LOWER horz.  vel1 & vel2 are the two control velocity
c  functions equally sampled to sample interval "si" (which is our fundamental
c  time sampling.
c---
      subroutine vbld3d (si, nsamp, nhor, nli, ndi, nmax, nfunc, lmax,
     1                   J, I, jneighb, ineighb, vels, horizons,
     2                   s, delt, ts, te, velt, tim1, zz, iz,
     3                   timt, wrkt, tim2, SZSMPD, name, irad)

#include <f77/iounit.h>

      integer  nsamp, nhor, nmax, nli, ndi, nfunc, J, I, SZSMPD
      integer  irad
      integer  jneighb (lmax), ineighb (lmax)
      real     vels (nsamp, nfunc), horizons (ndi, nli, nhor)
      real     s (nmax), delt (nmax)
      real     ts (nmax), te (nmax), tim1 (nmax), timt (nmax)
      real     velt (nmax), wrkt (nmax), tim2 (nmax)
      real     si
      character  name*(*)

      real        zz(4*nsamp)
      integer     iz(nsamp), ierr, iabort

      real     work
      pointer  (wkwork, work(1))

      logical  first

      rad = irad 

      iabort = 1
      item = nsamp
      call galloc (wkwork, item*SZSMPD, ierr, iabort)
      if (ierr .ne. 0) then
        write(LERR,*)' '
        write(LERR,*)'Unable to allocate workspace for ',name
        write(LERR,*) item * SZSMPD, '  bytes'
        write(LER ,*)' '
        write(LER ,*)'Unable to allocate workspace for ',name
        write(LER ,*) item * SZSMPD, '  bytes'
        call ccexit (666)
      endif

      do  ii = 1, nmax
          delt (ii) = 0.
          s    (ii) = 0.
          ts   (ii) = 0.
          te   (ii) = 0.
          tim1 (ii) = 0.
          timt (ii) = 0.
          wrkt (ii) = 0.
          tim2 (ii) = 0.
      enddo

      first  = .false.
      vlast  = 0.
      icinit = 1

c----
c  Loop over horizons building an output velocity trace as we go.
c----
      DO  L = 1, nhor+1

          if (L .eq. 1) then
              tst = 0.
          else
              tst = horizons (I, J, L-1)
          endif
          if (L .eq. nhor+1) then
              tet = si * (nsamp-1)
          else
              tet = horizons (I, J, L)
          endif
          deltt = tet - tst
          ist = nint (tst / si)
          iet = nint (tet / si)
          if (ist .eq. 0) ist = 1
          nst = iet - ist + 1

c----
c  find minimum & maximum separation between horizons
c----
         deltmn = +99999.
         deltmx = -99999.
         nstmn  = +99999
         nstmx  = -99999

         do  nf = 1, nfunc

             jr = jneighb(nf)
             ir = ineighb(nf)

             IF (.not. first) THEN

                njr = jr - J
                nir = ir - I
                if (njr .ne. 0 .OR. nir .ne. 0) then
                    xjr = njr
                    xir = nir
                    xd  = sqrt (xjr*xjr + xir*xir)
                    s (nf) = costap (rad, xd)
                else
                    s (nf) = 1.0
                endif


             ENDIF

             if (L .eq. 1) then
                 ts (nf) = 0.
             else
                 ts (nf) = horizons (ir, jr, L-1)
             endif
             if (L .eq. nhor+1) then
                 te (nf) = si * (nsamp-1)
             else
                 te (nf) = horizons (ir, jr, L)
             endif
             is = nint ( ts(nf) / si )
             if (is .eq. 0) is = 1
             ie = nint ( te(nf) / si )
             ns = ie - is + 1
             if (ns .le. nstmn) nstmn = ns
             if (ns .ge. nstmx) nstmx = ns

c----
c   compute the horizon time differences for the neighbor points. Then find
c   the minimum & maximum differences (and their locations) including the
c   output location
c----
             delt (nf) = te (nf) - ts (nf)

             if (delt(nf) .le. deltmn) then
                 deltmn = delt (nf)
                 jrmn = jr
                 irmn = ir
             endif
             if (delt(nf) .ge. deltmx) then
                 deltmx = delt (nf)
                 jrmx = jr
                 irmx = ir
             endif

         enddo

         if (deltt .le. deltmn) deltmn = deltt
         if (deltt .ge. deltmx) deltmx = deltt

c----
c   compute the min and max number of samples we're dealing with between
c   horizons
c----
         isepmn = nint (deltmn / si)
         isepmx = nint (deltmx / si)
         isepmx = max ( isepmx, nst, nstmx )
         isepmn = min ( isepmn, nst, nstmn )
         ns0 = isepmn

c----
c   build output location time vector
c----
         do  ii = 1, nst
             timt (ii) = si * float (ii-1)
         enddo

         item = isepmn * nfunc
         call grealloc (wkwork, item*SZSMPD, ierr, iabort)
         if (ierr .ne. 0) then
           write(LERR,*)' '
           write(LERR,*) item * SZSMPD, '  bytes'
           write(LERR,*)'At LI/DI ',j,i,' found ',nfunc,' functions'
           write(LERR,*)'Suggest decreasing radius of search'
           write(LER ,*)' '
           write(LER ,*)'Unable to allocate workspace for ',name
           write(LER ,*) item * SZSMPD, '  bytes'
           write(LER ,*)'At LI/DI ',j,i,' found ',nfunc,' functions'
           write(LER ,*)'Suggest decreasing radius of search'
           call ccexit (666)
         endif
         do  ii = 1, item
             work (ii) = 0.
         enddo


c----
c   go through the neighbor function locations and compute the number of samples
c   between current upper & lower horzs and do resampling to coarse SI
c----
         wt = 0
         do  nf = 1, nfunc

             is = nint (ts(nf) / si) + 1
             if (is .eq. 0) is = 1
             ie = nint (te(nf) / si)
             ns = ie - is + 1
             dtt = si * delt(nf) / deltmn

c----
c   build time vectors for the basic "si" sample interval & the coarse s.i.
c   then re-grid the velocities within the two horizons onto the coarse s.i.
c----
             do  it = 1, isepmx
                 tim1 (it) = si  * float (it-1)
                 tim2 (it) = dtt * float (it-1)
             enddo

             ipntr = (nf - 1) * isepmn + 1
             
             call fcuint (tim1, vels(is,nf), ns, tim2, work(ipntr), ns0,
     1                    iz, zz, icinit) 

             wt = wt + s (nf)

         enddo


         do  ii = 1, ns0
             wrkt (ii) = 0.
         enddo

         do  ii = 1, ns0
             do  nf = 1, nfunc
 
                 ipntr = (nf - 1) * isepmn + ii
                 wrkt (ii) = wrkt (ii) + s (nf) * work (ipntr)
             enddo
             wrkt (ii) = wrkt (ii) / wt

         enddo

         call fcuint (tim2, wrkt, ns0, timt, velt (ist), nst,
     1                iz, zz, icinit)

         if (vlast .gt. 0.) then
             velt (ist) = .5 * ( velt(ist) + vlast )
         endif
         vlast = velt (iet)
c----
c   For the current box position (I,J) we now have the local indeces for the
c   site of the minimum horz separation; the distances between the box center
c   and each of the function locations, and the distance weights for each
c----

         first = .true.

      ENDDO

      velt (nsamp) = velt (nsamp-1)

      return
      end
