C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE   logsmooth
C
C**********************************************************************C
C
C LOGS reads in log from an ascii file,
C applies a sophisticated 3-pt running statistical median conditioner
C to fix up errant data, then performs a multiple pass L-pt median
C smoother to block the logs and outputs these results to a file
C
C SUBROUTINE CALLS: rL, smooth3r
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

#include <f77/pid.h>

      REAL    * 4 s(10*SZSMPM), v(10*SZSMPM), rho(10*SZSMPM)
      REAL    * 4 z(10*SZSMPM)
      integer     npass, med
      real        dz

      CHARACTER   NAME * 4
      integer     argis
      logical     verbos,query
 
      DATA NAME     /'LOGSMOOTH'/

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE ARGUMENT STRING
C**********************************************************************C
      query = (argis('-?') .gt. 0)
      if(query) then
          call help()
          stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     read command line arguments
C**********************************************************************C
      call cmdln (med,npass,dz,verbos)

C**********************************************************************C
C     open i/o files
C     read in log
C**********************************************************************C
      do  1  J = 1, 10*SZSMPM
             read(LIN,*,end=2) z(j),v(j),rho(j)
             if (verbos)
     1       write(LERR,101)z(j),v(j),rho(j)
1     continue
101   format(3(f10.2,5x))
 

2     nlayer = J-1

      if (nlayer .lt. 2) then
         write(LERR,*)'LOGSMOOTH: less than 2 points in input log'
         write(LERR,*)'FATAL'
         stop
      endif

      if(verbos) then
         call verbal (nlayer,med,npass,dz)
      endif
 
C**********************************************************************C
C
C     READ TRACES, DO log smooth/blocking
C
C**********************************************************************C

c-----------------------------
c  do 3-pt running conditioner

              call smooth3r (v,s,nlayer)
              call vmov (s,1,v,1,nlayer)
              call smooth3r (rho,s,nlayer)
              call vmov (s,1,rho,1,nlayer)

c-----------------------------

c-----------------------------
c  do multiple pass blocker

              DO  5  J = 1, npass

                 call rL(v,s,nlayer,med)
                 call vmov (s,1,v,1,nlayer)
                 call rL(rho,s,nlayer,med)
                 call vmov (s,1,rho,1,nlayer)

5             CONTINUE

c-----------------------------

c------------------------
c  write output to stdout

              DO  7  I = 1, nlayer

                     write(LOT,111) z(I),v(I),rho(I)

7             CONTINUE
111           format( 3f10.3 )

c------------------------
	close (LIN)
        close (LOT)

      END

      subroutine cmdln (med,npass,dz,verbos)

      integer    argis, med, npass
      real       dz
      logical    verbos

          call argi4('-l',med,0,0)
          call argi4('-m',npass,1,1)
          call argr4('-d',dz,0.,0.)
          verbos = (argis('-V') .gt. 0)

      return
      end

      subroutine help

#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for LOGSMOOTH: log blocker'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-L[med]    -- length of median filter'
        write(LER,*)'-M[npass]  -- number of passes with L-pt median '
        write(LER,*)'              blocker'
        write(LER,*)'-D[dz]     -- depth interval'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)' '
        write(LER,*)'     logsmooth -L[] -M[] -D[] -V < input > output'
        write(LER,*)' '

      return
      end

      subroutine verbal (nsamp,med,npass,dz)

#include <f77/iounit.h>

c   nsamp   I   number samples/trace
c
c     med   I   median sort length
c   npass   I   number med. filter passes
c      dz   R   depth interval override

      integer    nsamp,med,npass
      real       dz

	write(LERR,*)' '
	write(LERR,*)' Values read from input data set'
	write(LERR,*)' '
        write(LERR,*) ' Number layers      =  ', nsamp
	write(LERR,*)' '
	write(LERR,*) ' Values from command line'
	write(LERR,*)' '
        write(LERR,*) ' Length of med filt =  ',med
        write(LERR,*) ' Number of passes   =  ',npass
        write(LERR,*) ' Depth interval (ft)=  ',dz
	write(LERR,*)' '

      return
      end
