C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c	3rssh
c
c   x - input data vector
c   y - output filtered vector
c   n - number of data values
c
      subroutine smooth3r( x, y, n )
      real x(*), y(*)

      if( n .lt. 3 )then
	call swap( x, y, n )  
      else
	call big3r( x, y, n )
	call peaks( x, y, n )
	call swap( x, y, n )
	call big3r( x, y, n )
	call peaks( x, y, n )
	call swap( x, y, n )
	call big3r( x, y, n )
	call hang( x, y, n )
      end if
      return
      end
c
      subroutine rough3r( x, y, z, n )
      real x(*), y(*), z(*)
      integer n
      integer i
      do 1 i = 1, n
	z(i) = x(i)
    1 continue 
      call smooth3r( x, y, n )
      do 2 i = 1, n
	y(i) = z(i) - y(i)
    2 continue
      return
      end
c
      integer function big3r( x,  y, n )
      integer n
      real x(*),  y(*)
      integer passes, stable
      passes  = 0
      call r3( x, y,  n )
      do    while( stable( x, y, n ) .le. 0 )
	passes = passes + 1
	call swap( x, y, n )
	call r3( x, y, n )
      end do
      call endpt( x,  y, n )
      big3r = passes
      return
      end
c
      subroutine  r3( x, y, n )
      integer n
      real x(*),  y(*)
      integer i
      real fm3
      do  1 i = 2, n-1
	y(i) = fm3( x(i-1), x(i), x(i+1) )
    1 continue
      y(1) =  x(1)
      y(n)=x(n)
      return
      end
c
      subroutine  endpt( x, y, n )
      integer n
      real x(*),  y(*)
      real erule
      x(1) =  erule( x(1), x(2), x(3) )
      x(n) =  erule( x(n), x(n-1), x(n-2) )
      return
      end
c
      real function fm3(  x, y, z )
      real x, y,  z
      real a(3),  t
      integer i,  j
      a(1) =  x
      a(2) = y
      a(3) = z
      do  1 i = 1, 2
      do 2 j = 1, 3-i
		if( a(j) .gt. a(j+1) ) then
	  		t = a(j)
                        a(j) = a(j+1)
                        a(j+1) = t
		end if
    2 continue
    1 continue
      fm3 = a(2)
      return
      end
c
      integer function stable ( x, y, n )
      integer n
      real x(*),  y(*)
      do  1 i = 1, n
	if( x(i) .ne. y(i) ) then
		stable = 0
		return
	end if
    1 continue
      stable  = 1
      return
      end
c
      subroutine  swap( x, y, n )
      integer n
      real x(*),  y(*)
      integer i
      real t
      do  1 i = 1, n
	t = x(i)
	x(i) = y(i)
	y(i) = t
    1 continue
      return
      end
c
      subroutine  peaks( x, y, n )
      integer n
      real x(*),  y(*)
      integer i
      real erule
      do  1 i = 1, n
	y(i) = x(i)
    1 continue
      if( n .lt.  4 ) then
      return
      end if
      do  2 i = 2, n-2
	if( x(i) .ne. x(i+1) ) then
c       	! do nothing
	else if( x(i) .eq. x(i-1) ) then
c       	! do nothing
	else if( x(i+1) .eq. x(i+2) ) then
c		! do nothing
	else if(( x(i-1) .gt. x(i) ) .and. ( x(i+1) .gt. x(i+2) )) then
c		! do nothing
	else if(( x(i-1) .lt. x(i) ) .and. ( x(i+1) .lt. x(i+2) )) then
c		! do nothing
	else
		if( i .gt. 2 ) then
	  		y(i) = erule( x(i), x(i-1), x(i-2) )
		else
	  		y(i) = x(i-1)
		end if
		if( i .lt. n-2 ) then
	  		y(i+1) = erule( x(i+1), x(i+2), x(i+3) )
		else
	  		y(i+1) = y(i+2)
		end if
	end if
    2 continue
      return
      end
c
      subroutine  hang( x, y, n )
      integer n
      real x(*),  y(*)
      integer i
      do  1 i = 2, n-1
	y(i) = 0.25 * ( x(i-1) + 2.0*x(i) + x(i+1) )
    1 continue
       y(1) =  x(1)
       y(n) = x(n)
      return
      end
c
      real function erule( x, y,  z )
      real fm3
      erule = fm3( x, y,  y-2.0*(z-y) )
      return
      end

