C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c-----
c   arrange input ray parameters, p, into ascending order;
c   build tables for time invariant resampling:

c   p --> angle   or

c   angle --> p

c   and determine whether spread is single ender or split and
c   if split where the center point is located
c-----

      subroutine tables (p, tabl1, tabl2, tmp, pmin, pamin,
     1                   pmax, pamax, split, neg, key, lapmin,
     2                   isym, ileft, irite, ntrc)

      real     p (*), tabl1 (*), tabl2 (*), tmp (*)
      integer  key (*)
      logical  split, neg

      deg = 180. / 3.14159265
      rad = 1. / deg

c----
c   sort p's into smallest (most neg) to largest (most pos)
c----
        call sortr  (p, key, ntrc)
        call vmov   (p, 1, tmp, 1, ntrc)
        call minv   (tmp, 1, pmin, lpmin, ntrc)
        call maxv   (tmp, 1, pmax, lpmax, ntrc)
        call minmgv (tmp, 1, pamin, lapmin, ntrc)
        call maxmgv (tmp, 1, pamax, lapmax, ntrc)

        V0 = 1 / pamax

      if (lapmin .gt. 1 .AND. lapmin .lt. ntrc) split = .true.
      if (.not.split .AND. (lpmin .ne. lapmin)) neg = .true.

      if (neg) then
         call vrvrs (tmp, 1, ntrc)
         call vabs  (tmp, 1, tmp, 1, ntrc)
      endif
c----
c   compute interpolation tables
c----

        angs = deg * asin ( tmp(1)    * V0 )
        ange = deg * asin ( tmp(ntrc) * V0 )
        dang = (ange - angs) / float(ntrc-1)

        do  k = 1, ntrc
            tabl1 (k) = tmp (k)
        enddo
        do  k = 1, ntrc
            ang = angs + (k-1) * dang
            tabl2 (k) = sin ( rad * ang ) / V0
        enddo

        call vmov (tmp, 1, p, 1, ntrc)

      return
      end
