C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine tpinit (nsamp,nspad,nw,ncmplx,nsi,si,fnyq,tp1,tp2,
     1                   numtp,fmax,ltaper,ftaper,domega,nwt1,nwt2,
     2                   delf,deltp,p,weight,taper,istpr,ntrc,vel)

c     routine to generate some parameters for tpstack
c
c     inputs:

c     nsamp   I   number samples/trace (from line header)
c      ntrc   I   number traces/rec (from line header)
c       nsi   I   sample interval (ms)
c       tp1   R   start value of tau-p
c       tp2   R   end value of tau-p
c     numtp   I   number tau-p values between tp1 & tp2
c      fmax   R   maximum frequency to use
c    ftaper   R   frequency to start tapering
c      nwt2   I   number inside traces to taper
c      nwt1   I   number outside traces to taper
c       vel   R   reference velocity
c
c     outputs:
c
c     nspad   I   power of 2 samples gt 2 * nsamp
c    ncmplx   I   number complex freq pairs
c        nw   I   number frequencies
c    ltaper   I   number taper frequencies
c     istpr   I   start tapering at freq index...
c        si   R   .001 * nsi
c      fnyq   R   nyquist freq
c    domega   R   delta omega
c         p   R   vector of tau-p values
c    weight   R   vector of taper weights
c     taper   R   vector of freq taper weights

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      real      weight(*), p(*), taper(*)
      integer   ordfft
      integer   nsamp,numtp,nwt1,nwt2,nw,nspad,nu,istpr,ltaper
      real      si,fnyq,delf,deltp,tp1,tp2,domega,pi,twopi
      real      fmax, ftaper


      pi = 3.14159265
      twopi = 2. * pi
      radian = pi/180.

      if (ntrc .le. 1) then
         write(LERR,*)'Input data must have more than 1 trc/rec'
         write(LERR,*)'Try reorganizing the line header with utop'
         stop
      endif

      nsamp2 = 2 * nsamp
      nu = ordfft (nsamp2)
      nspad = 2 ** nu
      ncmplx = nspad/2 + 1

      if (nsi .le. 32) then
          si = .001 * float (nsi)
      else
          si = .000001 * float (nsi)
      endif

      fnyq = 1./(2.*si)
      if (fmax .eq. 0.) then
         write(LERR,*)'Resetting fmax to 1/2 nyquist'
         fmax = .5 * fnyq
      endif
      if (fmax .gt. fnyq) then
         write(LERR,*)'fmax parameter exceeds nyquist= ',fnyq
         write(LERR,*)'Resetting fmax to 1/2 ffnyq and continuing'
         fmax = .5 * fnyq
      endif
      delf = fnyq/float(ncmplx-1)
      domega = twopi * delf
      nw = (twopi * fmax)/domega + 1

          numtp = ntrc
          write(LERR,*)'TAUPF:'
          write(LERR,*)'Using ',numtp,' input traces/rec'

c------------------------------
c command line input

c-----------------------------
c use start & end angles
c from command line

              deltp = (tp2 - tp1)/float(numtp-1)
              do  42  i = 1, numtp
                     pee  = tp1 + float(i-1) * deltp
                     p(i) = sin( pee *radian )/vel
42            continue

c---------------------
c  frequency taper?

      istpr = 0
      ltaper = 0
      if (ftaper .ne. 0.) then
          ltaper = (ftaper * twopi)/domega
          nw = nw + ltaper
      endif

c---------------------------------
c  have we exceeded x-form length?

      if (nw .gt. ncmplx) then
         write(LERR,*)'freq taper extends beyond nyquist'
         write(LERR,*)'taper frequency= ',ftaper,' too high'
         write(LERR,*)'reduce it & try again'
         stop
      endif
      
c--------------------------------
c  if so we've added ltaper
c  points to the no. freqs to
c  account for taper, which is a
c  cosine ** 2

      if (ltaper .ne. 0) then
          istpr = nw - ltaper + 1
          dang = .5 * pi / float(ltaper)
          ang = 0.
          do  5  i = 1, ltaper
                 xcos = cos (ang)
                 taper(i) = xcos*xcos
                 ang = ang + dang
5         continue
      endif

 
c---------------------
c  compute weights

      if (nwt1 .gt. ntrc/2 .or. nwt2 .gt. ntrc) then
         write(LERR,*)'Error in input of spatial traces - '
         write(LERR,*)'No tapering applied'
         nwt1 = 0
         nwt2 = 0
      endif
      if (nwt1 .lt. 0) nwt1 = 0
      if (nwt2 .lt. 0) nwt2 = 0
      do  20  j = 1, ntrc
          weight ( j ) = 1.0
20    continue

      if (nwt1 .gt. 0) then
         do  22  j = 1, nwt1
                 weight(j) = float(j)/float(nwt1+1)
                 weight(ntrc-j+1) = weight(j)
22       continue
      endif

      if (nwt2 .gt. 1) then
         do  24  j = 1, nwt2/2
                 wtemp = float(j)/(float(nwt2)/2. +1.)
                 weight(ntrc/2 - j + 1) = wtemp
                 weight( (ntrc+1)/2 + j) = wtemp
24       continue
         if (ntrc/2*2. .ne. ntrc) weight(ntrc/2 + 1) = 0.
      endif

      

      return
      end
