C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine pwmute (tri,rayp,vel,nsamp,nramp)

c  routine to apply ray parameter dependent mute to
c  tau-p traces

c  input:

c     tri  -  inpute trace
c    rayp  -  ray parameter from tau-p trace header
c     vel  -  velocity vector
c   nsamp  -  number samples
c   nramp  -  number samples in linear mute ramp

c output:

c     tri  -  output trace

#include <f77/iounit.h>

      real    tri(*), vel(*)
      real    rayp, vp
      integer nsamp, nramp, icur, ist

      if ( abs(rayp) .gt. 1.e-06) then
          vp = 1./rayp
      else
          vp = 1./1.e-10
      endif

      do 1  i  =  1, nsamp
          if (vp .le. vel(i)) then
              ist = i
              go to 2
          endif
1     continue

      ist = nsamp
2     continue

c-------------------
c  linear mute ramp 
c      do  5  i  =  ist, ist+nramp
c             tri(i) = tri(i) * float(nramp-i)/float(nramp)
c5     continue
      icur = ist

      if (icur .lt. nsamp)
     *call vclr (tri(ist),1,nsamp-icur+1)

      return
      end
