C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE migsub (NT,NZ,NTR,NV,DZ,DT,V0,TRACES,A,ANG,V,
     1                   ist, iend, irs, nrec, vmin, vmax,
     2                   logsc, slowness)
C
C   SUBROUTINE TO MIGRATE PLANE WAVES IN A VERTICALLY INHOMOGENEOUS
C   MEDIUM
C
C   THE METHOD ESSENTIALLY PARALLELS THE DOWNWARD CONTINUATION
C   PAPER BY CLAYTON & MCMECHAN (GEOPH. V.46 P.860-868) FOR REFRACTION
C   WAVEFIELDS.  WE CHOOSE TO IMAGE THE REFLECTED WAVEFIELD USING
C   THE EXPRESSION FOR THE DOWNGOING WAVE DERIVED FROM GEOMETRICAL
C   OPTICS:
C                                 Z
C                   U(Z) = EXP(-I S K(Z) DZ)
C                                 0
C
C   (SEE ALSO TREITEL & ROBINSON, F81-E-6, P. 70)
C
C   WHERE,          K(Z) = W COS(GAMMA(Z))/V(Z)
C
C   W - FREQUENCY IN RAD/SEC
C   GAMMA(Z) - ANGLE OF EMERGENCE AT DEPTH Z, DERIVED FROM SNELL'S LAW
C   V(Z) - GIVEN VELOCITY-DEPTH FUNCTION
C
C   INPUTS:
C          NZ - NUMBER OF DEPTH POINTS IN OUTPUT IMAGE RAY TRACE
C          NT - NUMBER OF AVAILABLE TIME POINTS IN INPUT ARRAY
C         NTR - NUMBER OF INPUT PLANE WAVE TRACES
C          NV - NUMBER OF OUTPUT PLANE WAVE TRACES (velocities)
C          DZ - DEPTH INCREMENT (ft,m)
C          DT - TIME INCREMENT (sec)
C         IRS - STARTING RECORD (sequential)
C        NREC - CURRENT  RECORD (sequential)
C        VMIN - MINIMUM VELOCITY IN SCAN
C        VMAX - MAXIMUM VELOCITY IN SCAN
C       LOGSC - IF TRUE, DO LOG DISTRIBUTION OF SCAN VELOCITIES
C    SLOWNESS - IF TRUE, DO SCAN OF SLOWNESSES (instead of vels)
C          V0 - SURFACE VELOCITY (KFT)
C      TRACES - MATRIX OF PLANE WAVE INPUT DATA (TIME DOMAIN)
C         ANG - VECTOR OF INPUT RAY PARAMS SQUARED ( p **2)
C   OUTPUT:
C           A - ARRAY OF DEPTH IMAGED TRACES AS FUNCTION OF P, OR
C               PHASE VELOCITY (either linear or log scale)
C           V - VECTOR OF VELOCITIES USED IN THE SCANS
C
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      Real         TRACES(NT,ntr),A(NZ,NV)
      Real         ANG(*), V(*)
      Real         WTRCE(SZLNHD)
      logical      logsc, slowness
C
      REAL         PI
      PI = 3.14159265

      fac = 2. * dz / dt
C
C   LOOP 0 IS OVER ALL TRIAL VELOCITIES

      NVEL = NV
      dvel = (vmax-vmin)/(NVEL-1)
      if (logsc) then
         v1 = log (vmin)
         v2 = log (vmax)
         dvel = (v2 - v1)/float(nvel-1)
      else
         v1 = vmin
         v2 = vmax
         dvel = (vmax-vmin)/(NVEL-1)
      endif

      if(slowness) then
         if (logsc) then
            smin2 = log((1./vmax)**2)
            smax2 = log((1./vmin)**2)
            ds2   = (smax2-smin2)/(nvel-1)
         else
            smin2 = (1./vmax)**2
            smax2 = (1./vmin)**2
            ds2   = (smax2-smin2)/(nvel-1)
         endif
      endif

C
 
      if (nrec .eq. irs) then
         write(LERR,*)'Velocity increment = ',dvel
         write(LER ,*)'Velocity increment = ',dvel
      endif

C  SCAN OVER ALL VELOCITIES BETWEEN VMIN & VMAX

      DO  IR = 1, NV

            if(slowness) then
               if (logsc) then
                  s2  = exp(smin2+(ir-1)*ds2)
                  vel = sqrt(1./s2)
               else
                  s2  = smin2+(ir-1)*ds2
                  vel = sqrt(1./s2)
               endif
            else
               if (logsc) then
                  vel = exp (v1 + float(ir-1)*dvel)
               else
                  vel = v1+(ir-1)*dvel
               endif
            endif

c           V (IR) = vel

 
C**********************************************************************C
C
C   LOOP 1 IS OVER ALL RAY PARAMETERS
C
      DO 1 J = 1, NTR

           do  ii = 1, nt
               wtrce (ii) = 0.
           enddo

           BSQ = ANG(J)
C
C   LOOP 2 IS OVER DEPTH/TIME
C
           TAU = 0.
           DO 2 I = 1, NT
C
C   WE COMPUTE THE QUANTITY
C
C                    I
C        TAU1 = DZ * E SQRT(CEE(ZJ)**2 - SIN(ANG(J))**2) / V0
C                   J=0
C
C   WHICH IS THE DISCRETE VERSION OF THE GEOMETRICAL OPTICS EXPRESSION
C   AND WHICH IS THE MOVEOUT OR STACKING TIME FOR VARIABLE VELOCITY
C
              asq = 1. / vel
              asq = asq * asq
C
C   TAKE ABSOLUTE VALUE INSIDE SQRT SIGN TO PREVENT ARTIFICIAL
C   EVENESCENCE, I.E. WE STILL WANT A PHASE FACTOR BELOW P = 1/V(Z)
C
              CSQ = SQRT ( ABS(ASQ - BSQ) )
C
C   SUMMATION ACCUMULATES AS WE GO DEEPER INTO THE MODEL
C
              TAU   = TAU + CSQ
C
C   FOR TRACE J COMPUTE THE CORRESPONDING SAMPLE POINT IJ
C
              XIJ   =      TAU * fac
              IJ  = IFIX (XIJ) + 1
C
C   PUT THE MOVED POINT INTO WORK VECTOR USING LINEAR INTERPOLATION
C   AND OVERLAY DATA HAVING COMMON INDEXES
C
              c1 = float(ij) - xij
              c2 = 1. - c1
              
              if (ij .ge. ist .AND. ij .le. iend) then
                 WTRCE(I) =  WTRCE(I) +
     1                       abs( c1 * TRACES(IJ-1,J) + 
     2                            c2 * TRACES(IJ,J)    )
              elseif (ij .lt. 2) then
                 WTRCE(I) =  WTRCE(I) +
     1                       abs( TRACES(IJ,J) )
              else
                 WTRCE(I) = 0.0
              endif

    2      CONTINUE
C
C   ACCUMULATE MIGRATED DATA TO OUTPUT IMAGE ARRAY
C
           do  i = 1, NZ

               A (i,J) = A (i,J)  + wtrce (i)
           enddo

C
C   GO BACK TO THE TOP LOOP AND INCREMENT J
C
    1 CONTINUE

      ENDDO


      RETURN
      END
