C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine x2t2 (y,dt,n,p,v,gamma,tol,remove)
c
c     y = data trace
c     v = velocity trace (velocity vs sample)
c    dt = sample interval
c     n = number samples/trace
c     p = ray parameter
c   tol = use this % of the ellipse measured from p=0
c remove= if true to 'unmormal movelout'
c
#include <f77/lhdrsz.h>

      real     sinei,p,tol,tnmo
      real     y(*), v(*), gamma(*)
      real     z(SZLNHD)
      integer  j,i,n
      logical  remove

      deg = 180. / 3.14159265

      call vclr (z,1,n)
      call vclr (gamma,1,n)

c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  remove nmo (inverse nmo)

      IF (remove) THEN

         do 2000 i = n,1,-1

              sinep = p * v(i)
              sinei = abs ( sinep )

              if(sinei .le. tol) then

                 tnmo = (i-1) * sqrt( abs(1. - sinei*sinei) )
                 j= tnmo
                 f    = tnmo - j
                 fs   = f * f
                 c1   = fs - f
                 c2   = 2.0 - 2.0 * fs
                 c3   = fs + f
c-------
c      check for bounds
c-----
                 if (i .gt. 1 .and. i .lt. n) then
c                   z(j) = y(i) +  f * (y(i-1) - y(i))
                    z(j) = .5 * (
     1                     c3 * y(i-1) + c2 * y(i) + c1 * y(i+1)
     2                          )
                 else
                    z(j) = 0.
                 endif

              endif

 2000    continue

c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      ELSE
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  apply nmo (forward nmo)

         do 1000 i = 1,n

              sinep = p * v(i)
              sinei = abs ( sinep )

              if(sinei .le. tol) then

                 tnmo = (i-1) * sqrt ( abs(1. - sinei*sinei) )
                 j    = tnmo
                 f    = tnmo - j
                 fs   = f * f
                 c1   = fs - f
                 c2   = 2.0 - 2.0 * fs
                 c3   = fs + f
c---------------------------------------
c      check for bounds
c-----

                 if (j .gt. 1 .and. j .lt. n) then
c-------------
c  interpolate
c                    z(i) = y(j) +  f * (y(j+1) - y(j))
                     z(i) = .5 * (
     1                      c1 * y(j-1) + c2 * y(j) + c3 * y(j+1)
     2                           )
                 else
                     z(i) = 0.
                 endif
c---------------------------------------
              else
                     z(i) = 0.
              endif

              if (sinei .ge. .9999) then

                  if (sinep .ge. 0.) then
                     gamma(i) = +90.
                  else
                     gamma(i) = -90.
                  endif
              else
                  sgn = sign (1.0, sinep)
                  gamma(i) = sgn * deg * asin ( sinei )
              endif

 1000    continue

      ENDIF

c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      call vmov (z, 1, y, 1, n)
 
 


      return
      end
