C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine border(cdata,fac,nx,nomega)
C/---------------------------------------------------------------------
C/REM/             Proprietary of CONSORTIUM P.S.I.
C/REM/               Institut Francais du Petrole
C/REM/               92500 Rueil Malmaison FRANCE
C/REM/ 
C/REM/                    All rights reserved
C/
C/NAME/  (subroutine name):  border
C/
C/CALL/  call border(cdata,fac,nx,nomega)
C/
C/HIST/  creation    author: Andreas Ehinger
C/HIST/              date:   28.07.1993
C/HIST/
C/HIST/  modifications
C/HIST/  (author)      (date)       (modification)        (tested(y/n))
C/HIST/
C/
C/PURP/  apply x-dependent taper to data matrix
C/
C/DESC/  taper coefficients may be calculated with subroutine tapcoef
C/
C/ARG/   in    : fac      real taper coefficients [nx]
C/ARG/   in               nx,nomega
C/ARG/   in-out: cdata    complex data matrix [nomega,nx]
C/ARG/   out   : -
C/
C/LOCAL/ -
C/
C/FILES/ -
C/
C/DOWN/  -
C/
C/EXPL/  -
C/
C/-------------------------------------------------------------------
c
c     declaration of arguments
      integer nx,nomega
      complex cdata(nomega,nx)
      real fac(nx)
 
c     declaration of local variables
      integer ix,io
c
c-----------------------------------------------------------------------
c
c     application of taper
      do 50 ix=1,nx
         do 60 io=1,nomega
            cdata(io,ix) = cdata(io,ix)*fac(ix)
60       continue
50    continue
c
      end 
