C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine paraxinit(f1,f2,f2coeff,ifl,ifh,
     1                     alpha,beta,tap,lenap,
     2                     dcrp,teta,domega,alphat,
     3                     order_pade,maxorder_pade,nxtaper,lerr)
c_______________________________________________________________________
c     initialize matrices for paraxial solution.
c_______________________________________________________________________
      integer order_pade,maxorder_pade
      real    tap(lenap)
      complex f1(ifl:ifh,order_pade),f2(ifl:ifh,order_pade)
      complex f2coeff(ifl:ifh,order_pade)
      real    alpha(maxorder_pade),beta(maxorder_pade)
c
      complex omega
c
      dcrp2=dcrp*dcrp
C_______________________________________________________________________
c     calculate paraxial coefficients
C_______________________________________________________________________
      call pawep(kap,order_pade,alpha,beta,maxorder_pade)
C_______________________________________________________________________
c     calculate paraxial coefficients
C_______________________________________________________________________
      call tapcoef(tap,lenap,nxtaper)
c_______________________________________________________________________
c     precalculate functions f1 and f2coeff outside the main loop.
c_______________________________________________________________________
      do 12000 iap=1,order_pade
       do 11000 ifreq=ifl,ifh  
        omega=cmplx(ifreq*domega,alphat)
        f1(ifreq,iap)=alpha(iap)/(dcrp2*omega**2)
        f2coeff(ifreq,iap)=(beta(iap)*teta)/(dcrp2*omega)
11000  continue
12000 continue
c
      return
      end
