C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine pawep(kap,nap,alpha,beta,napmax)
C/---------------------------------------------------------------------
C/REM/             Proprietary of CONSORTIUM P.S.I.
C/REM/               Institut Francais du Petrole
C/REM/               92500 Rueil Malmaison FRANCE
C/REM/ 
C/REM/                    All rights reserved
C/
C/NAME/  (subroutine name):  pawep
C/
C/CALL/  call pawep(kap,nap,alpha,beta,napmax)
C/
C/HIST/  creation    author: Andreas Ehinger
C/HIST/              date:   12.02.1990
C/HIST/
C/HIST/  modifications
C/HIST/  (author)      (date)       (modification)        (tested(y/n))
C/HIST/
C/
C/PURP/  define paraxial approximation parameters
C/
C/DESC/  -
C/
C/ARG/   in    : kap  approximation to be used
C/ARG/   in-out: -
C/ARG/   out   : -
C/
C/LOCAL/ -
C/
C/FILES/ -
C/
C/DOWN/  -
C/
C/EXPL/  -
C/
C/-------------------------------------------------------------------
c     declaration of arguments
      integer kap,nap,napmax
      real alpha(napmax),beta(napmax)
c
c     declaration of local variables
      real pi,xnn
      integer inap
c
c-----------------------------------------------------------------------
c
      pi = 4.*atan(1.)
c
      if (kap .eq. 1) then
c        parabolic wave equation parameters
         nap = 1
         alpha(1) = 0. 
         beta(1) = 0.5
      elseif (kap .eq. 2) then
c        Pade-parameters 45degree
         nap = 1
         alpha(1) = 0.25 
         beta(1) = 0.5
      elseif (kap .eq. 3) then       
c        Pade-parameters 60degree
         nap = 2
         alpha(1) = cos(pi/5.) * cos(pi/5.)
         beta(1) = 2./5. * sin(pi/5.) * sin(pi/5.)
         alpha(2) = cos(2.*pi/5.) * cos(2.*pi/5.)

         beta(2) = 2./5. * sin(2.*pi/5.) * sin(2.*pi/5.)
      elseif (kap .ge. 4) then       
c        higher Pade parameters
         nap = kap-1
         xnn = 2.*nap + 1
         do 100 inap=1,nap
            alpha(inap) = (cos(inap*pi/xnn))**2
            beta(inap) = 2./xnn * (sin(inap*pi/xnn))**2
100      continue
      endif
c
      end
