C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine shift1(cdata,vz,vfac,cphi1,cphi2,cphi,bcos,
     +                       dz,nx,omegamin,domega,nomega,alphat)
C/---------------------------------------------------------------------
C/REM/             Proprietary of CONSORTIUM P.S.I.
C/REM/               Institut Francais du Petrole
C/REM/               92500 Rueil Malmaison FRANCE
C/REM/
C/REM/                    All rights reserved
C/
C/NAME/  (subroutine name):  shift1
C/
C/CALL/  call shift1(cdata,vz,vfac,cphi1,cphi2,cphi,bcos
C/CALL/                   dz,nx,omegamin,domega,nomega)
C/
C/HIST/  creation    author: Andreas Ehinger
C/HIST/              date:   27.07.1993
C/HIST/
C/HIST/  modifications
C/HIST/  (author)      (date)       (modification)        (tested(y/n))
C/HIST/
C/
C/PURP/  solve the transport problem
C/
C/DESC/  -
C/
C/ARG/   in    : vz       velocity field in fixed depth [nx]
C/ARG/           vfac     local array of this subroutine [nx]
C/ARG/           cphi1    local array of this subroutine [nx]
C/ARG/           cphi2    local array of this subroutine [nx]
C/ARG/           cphi     local array of this subroutine [nx]
C/ARG/           bcos     local array of this subroutine [nx]
C/ARG/           dz,nx,omegamin,domega,nomega
C/ARG/   in-out: cdata    complex data matrix [nomega,nx]
C/ARG/   out   : -
C/
C/LOCAL/ -
C/
C/FILES/ -
C/
C/DOWN/  -
C/
C/EXPL/  -
C/
C/--------------------------------------------------------------------
c
c     declaration of arguments
      integer    nomega,nx
      complex    cdata(nomega,nx)
      real       vz(nx),vfac(nx),bcos(nx)
      complex    cphi1(nx),cphi2(nx),cphi(nx)
      real       dz,omegamin,domega,alphat
      complex    ci,arg
 
c     declaration of local variables
      real       b,dzo2
      integer    ix,io
      parameter  (ci=(0.,1.))

c-----------------------------------------------------------------------
c
c     computation of cphi1(ix), cphi2(ix) and bcos(ix)
c
      dzo2 = dz/2.          

      vfac(1) = dz/vz(1)

      do 50 ix=2,nx
         vfac(ix) = dzo2/vz(ix) + dzo2/vz(ix-1)
50    continue

      do 100 ix=1,nx
         arg = cmplx(omegamin,alphat)*vfac(ix)
         cphi1(ix)=exp(ci*arg)         
         b = domega*vfac(ix)
         cphi2(ix)=cphi1(ix) * cmplx(cos(b),sin(b))
         bcos(ix)=2.*cos(b)
100   continue 
c
c     multiplication of first frequency-component of source
c     with cphi1 and multiplication of second frequency-
c     component with cphi2
      do 110 ix=1,nx
         cdata(1,ix) = cdata(1,ix) * cphi1(ix)
110   continue
      if(nomega .ge. 2) then
         do 115 ix=1,nx
          cdata(2,ix) = cdata(2,ix) * cphi2(ix)
115      continue
      endif
c
c     evaluation of the next shifts with the recursion formula and
c     application of the shift 
c
      do 120 io=3,nomega
         do 130 ix=1,nx
c
            cphi(ix)=bcos(ix) * cphi2(ix) - cphi1(ix)
            cdata(io,ix) = cdata(io,ix) * cphi(ix)
c
130      continue
c
c        exchange of vectors cphi,cphi1 und cphi2 for application 
c        of the recursion formula
         do 140 ix=1,nx
            cphi1(ix) = cphi2(ix)
            cphi2(ix) = cphi(ix)
140      continue
c
120   continue              
c
      end
