C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine tapcoef(fac,nx,ntaper)
C/---------------------------------------------------------------------
C/REM/            Proprietary of CONSORTIUM P.S.I.
C/REM/               Institut Francais du Petrole
C/REM/               92500 Rueil Malmaison FRANCE
C/REM/ 
C/REM/                    All rights reserved
C/
C/NAME/  (subroutine name):  tapcoef
C/
C/CALL/  call tapcoef(fac,nx,ntaper)
C/HIST/  creation    author: Andreas Ehinger
C/HIST/              date:   27.07.1993
C/HIST/
C/HIST/  modifications
C/HIST/  (author)      (date)       (modification)        (tested(y/n))
C/HIST/
C/
C/PURP/  compute x-dependent cos-taper coefficients
C/
C/DESC/  -
C/
C/ARG/   out   : fac, taper coefficients [nx]
C/ARG/   in    : nx,ntaper
C/
C/LOCAL/ -
C/
C/FILES/ -
C/
C/DOWN/  -
C/
C/EXPL/  -
C/
C/-------------------------------------------------------------------
c
c     declaration of arguments
      integer nx,ntaper
      real    fac(nx)

c     declaration of local variables
      real    taper,pi
      integer ix,j
c
c-----------------------------------------------------------------------
c
      pi=acos(-1.)
      taper = ntaper/pi
c
c     computation of ascending branch of taper
      do 10 ix=1,ntaper
         fac(ix) = 0.5 * ( 1.-cos(ix/taper) )
10    continue
c
c     computation of constant region
      do 20 ix=ntaper+1,nx-ntaper
         fac(ix) = 1.
20    continue

c     computation of descending branch of taper
      j=ntaper
      do 30 ix=nx-ntaper+1,nx
         fac(ix) = 0.5 * ( 1.-cos(j/taper) )
         j=j+1
30    continue
c
      end 
