C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine twt(v,time,buffer,firstcrp,lastcrp,
     1               xvo,dxgrid,nz,zeta,nxgrid,lenhed,lutwt,nbyptr,
     2               l_recind,l_recnum,dsta)
C
      integer*2 buffer(*)                         
      real      time(-lenhed:nz)               
      dimension v(0:nz,nxgrid)
      real      zeta(0:nz)
      integer   firstcrp,lastcrp
c_______________________________________________________________________
c     clear headers.                       
c_______________________________________________________________________
      call vclr(time(-lenhed),1,lenhed)
c_______________________________________________________________________
c     loop over all possible crp locations.
c_______________________________________________________________________
      do 20000 icrp=firstcrp,lastcrp
       xcrp=icrp*dxgrid
       irecind=nint(xcrp/dsta)
       ixgrid=nint((xcrp-xvo)/dxgrid)
       ixgrid=max(1,ixgrid)
       ixgrid=min(nxgrid,ixgrid)
c
       buffer(l_recind)=irecind
       buffer(l_recnum)=icrp
c_______________________________________________________________________
c      integrate the slowness.             
c_______________________________________________________________________
       time(0)=0.                     
c
       do 10000 izeta=1,nz
        dzeta=zeta(izeta)-zeta(izeta-1)
        time(izeta)=time(izeta-1)+2./v(izeta,ixgrid)*dzeta
10000  continue
C
       call wrtape(lutwt,time(-lenhed),nbyptr)
20000 continue
C
      return
      end
