C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine wrtime(rbuffer,ibuffer,cbuffer,cdata,hbegin,ntcalc,
     1                  ifl,ifh,minap,maxap,unwrap,lugreen,nbytes_out,
     2                  lentr2,l_RecNum,irec)
c
      integer   hbegin
      real      rbuffer(hbegin:ntcalc,minap:maxap)
      integer*2 ibuffer(lentr2,minap:maxap)
      complex   cbuffer(0:ntcalc/2-1)
      complex   cdata(ifl:ifh,minap:maxap)
      real      unwrap(ntcalc)                 
c_______________________________________________________________________
c     output the impulse response at the current depth level in the
c     time domain.
c_______________________________________________________________________
      do 80000 icrp=minap,maxap
c_______________________________________________________________________
c      fill the transformed array from 0 to ntcalc/2-1
c_______________________________________________________________________
       call vclr(cbuffer,1,ntcalc)
       do 60000 ifreq=ifl,ifh  
        cbuffer(ifreq)=conjg(cdata(ifreq,icrp))
60000  continue
c_______________________________________________________________________
c      transform from omega --> t
c_______________________________________________________________________
       call rfftb(cbuffer,rbuffer(1,icrp),ntcalc,-1)
80000 continue
c_______________________________________________________________________
c      unwrap and flip
c_______________________________________________________________________
       do 70000 k=1,ntcalc
        do 65000 icrp=minap,maxap
         rbuffer(k,icrp)=rbuffer(k,icrp)*unwrap(k)
65000   continue
70000  continue
c_______________________________________________________________________
c      output the results
c_______________________________________________________________________
      do 90000 icrp=minap,maxap
       ibuffer(l_RecNum,icrp)=irec
       call wrtape(lugreen,rbuffer(hbegin,icrp),nbytes_out)
90000 continue
c
      return
      end
