/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef LHDRSZ_H
#define LHDRSZ_H

#include <localsys.h>

/*----
c      SZDTHD	- size of trace header on disk in bytes
c      SZINPH   - size integer trace plus header
c      SZTRHD	- size of trace header in pipes in bytes
c      LNTRHD   - size of trace header in samples
c      SZDVHD	- size of vanl analysis header on disk in bytes
c      SZVAHD	- size of vanl analysis header in pipes in bytes
c      SZSAMP	- size of floating point sample in bytes
c      SZSMPM	- maximum number of trace samples
c      SZLNHD	- line file size = (SZTRHD + SZSAMP*MAXSMP)/2
c      SZSPRD   - size of the spread in channels
c      SZSMPD   - size of sample in pipe (in bytes)
c      HSTOFF   - byte count at which hlh starts
c      VDVOFF   - byte count at which v-dv pairs start in vanl format data
c      SZHFWD   - size in bytes of 1/2 word
c      ITRWRD   - number of full words (memory) in trace header
c      ITHWP1   - ITRWRD + 1
c      ISZBYT   - number of bytes in a word (memory) for this system
----*/
#define SZDTHD 256
#define LNTRHD 128
#define SZDVHD 2112
#define SZSAMP 4
#define SZLNHD 10000

#ifndef CRAYSYSTEM
#   define SZTRHD 256
#   define SZSMPD 4
#   define SZSMPM 4096
#   define SZINPH 4128
#   define SZVAHD 2112
#   define SZSPRD 1000
#   define HSTOFF 1004
#   define VDVOFF 64
#   define SZHFWD 2
#   define ITRWRD 64
#   define ISZBYT 4
#   define ITHWP1 65
#else
#   define SZTRHD 1024
#   define SZSMPD 8
#   define SZSMPM 8192
#   define SZINPH 8320
#   define SZVAHD 4272
#   define SZSPRD 1500
#   define HSTOFF 2592
#   define VDVOFF 176
#   define SZHFWD 8
#   define ITRWRD 128
#   define ISZBYT 8
#   define ITHWP1 129
#endif

#endif
