/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef __cdds_h
#define __cdds_h
/* "cdds.h" C Application Program Interface, Data Dictionary System */

#define DDSVERSION 2
#define DDSREVISION 4
#define DDSVersion (DDSVERSION * 1000 + DDSREVISION)
#define DDSVERSION_STRING "$Revision: 2.4 $"


#ifdef  __cplusplus
extern "C" {
#endif

#ifdef __convex__
typedef off64_t HUGE_OFFSET;	/* byte offset to stream position */
#elif defined(ATIO)
typedef long long HUGE_OFFSET;	/* byte offset to stream position */
#else
typedef long HUGE_OFFSET;	/* byte offset to stream position */
#endif

#ifdef __sgi
#define LONG_DOUBLE_OK double
#else /* __sgi */
#define LONG_DOUBLE_OK double
/*** #define LONG_DOUBLE_OK long double ***/
#endif /* __sgi */

/* maximum number of cube dimensions */
#define RANK_MAX 9

/* maximum number of characters in one component of a filename */
#define BASENAME_MAX 255
#define BASENAME_MAXQ "255"
 
/* maximum number of characters in a fully qualified filename */
#define PATHNAME_MAX 1023
#define PATHNAME_MAXQ "1023"
 
/* maximum number of characters in a DDS definition name */
#define DEFNNAME_MAX 63
#define DEFNNAME_MAXQ "63"
 
/* maximum number of characters in a cube axis name */
#define AXISNAME_MAX 31
#define AXISNAME_MAXQ "31"
 
/* maximum number of characters in a axis units name */
#define UNITNAME_MAX 31
#define UNITNAME_MAXQ "31"

/* big string size for a list of dictionary names */
#define DICTLIST_MAX 8191
#define DICTLIST_MAXQ "8191"
 
/* big string size for a list definitions names */
#define ALIASLIST_MAX 8191
#define ALIASLIST_MAXQ "8191"
 
/* non-character, character */
#define NON_CHAR '\275'
#define NON_CHARQ "\275"
 
/* error return status */
#define DDS_ERROR EOF

/* correspondence between host binary types and DDS prime types */
#ifdef cray

#define DDS_BYTE			"byte1"
#define DDS_CHAR			"ascii1"
#define DDS_UNSIGNED			"unsigned8"
#define DDS_UNSIGNED_SHORT		"unsigned8"
#define DDS_UNSIGNED_LONG		"unsigned8"
#define DDS_INT				"integer8"
#define DDS_SHORT			"integer8"
#define DDS_LONG			"integer8"
#define DDS_FLOAT			"float8cray"
#define DDS_DOUBLE			"float8cray"
#define DDS_LONG_DOUBLE			"float8cray"
#define DDS_COMPLEX			"complex16cray"

#else /* default macros (4 byte word hosts) */

#define DDS_BYTE			"byte1"
#define DDS_CHAR			"ascii1"
#define DDS_UNSIGNED			"unsigned4"
#define DDS_UNSIGNED_SHORT		"unsigned2"
#define DDS_UNSIGNED_LONG		"unsigned4"
#define DDS_INT				"integer4"
#define DDS_SHORT			"integer2"
#define DDS_LONG			"integer4"
#define DDS_FLOAT			"float4"
#define DDS_DOUBLE			"float8"
#define DDS_LONG_DOUBLE			"float8"
#define DDS_COMPLEX			"complex8"

#endif

typedef int BIN_TAG;            /* binary subscript */
 
typedef int TYPE_TAG;           /* type subscript */
 
typedef int FIELD_TAG;          /* frame field subscript */

typedef int TIME_TAG;		/* timer subscript */

/* DDS_STREAM corresponds to TYPE_STREAM for byte access */
#define DDS_STREAM	5

typedef struct DISCO_HEADER
{  /* disco VDS trace header table (followed by DISCO_FIELD entries) */
   int magic;               /* header constant (magic ?) */
   int count;               /* number of entries in header */
   int length;              /* length of the header in words */
} DISCO_HEADER;

typedef enum {
   /* media genus for dictionaries and binary data */
   GENUS_NULL,		/* null media */
   GENUS_TTY,		/* terminal access */
   GENUS_DISK,		/* random access */
   GENUS_PIPE,		/* sequential access */
   GENUS_MEMORY,	/* real memory, fast, random access */
   GENUS_TAPE,		/* tape (character special device) */
   MEDIA_GENUS_MAX
} MEDIA_GENUS;


/*** #if (defined(ANSI) | defined(__cplusplus)) ***/

#if defined(FUNCPROTO) || defined(ANSI) || __STDC__ || defined(__STDC__) || \
   __SUNPRO_C || defined(__cplusplus) || defined(c_plusplus)

/* ANSI style function prototypes */

int cdds_dict(
   const char *name,
   const char *mode)
;
int cdds_extend(
   const char *dict)
;
int cdds_copy(
   const char *alias)
;
int cdds_history(void)
;
int cdds_copyhist(void)
;
const char * cdds_in(
   const char *in_alias,
   const char *in_value,
   const char *title)
;
const char * cdds_out(
   const char *out_alias,
   const char *out_value,
   const char *history)
;
const char * cdds_mod(
   const char *mod_alias,
   const char *mod_value,
   const char *title,
   const char *history)
;


int cdds_incube(
   int *old_rank,
   int old_size[RANK_MAX],
   float old_origin[RANK_MAX],
   float old_delta[RANK_MAX],
   float old_base[RANK_MAX],
   float old_step[RANK_MAX],
   char old_axis[RANK_MAX][AXISNAME_MAX+1],
   char old_units[RANK_MAX][UNITNAME_MAX+1],
   char old_sort[RANK_MAX][DEFNNAME_MAX+1])
;
int cdds_outcube(
   int new_rank,
   int new_size[RANK_MAX],
   float new_origin[RANK_MAX],
   float new_delta[RANK_MAX],
   float new_base[RANK_MAX],
   float new_step[RANK_MAX],
   char new_axis[RANK_MAX][AXISNAME_MAX+1],
   char new_units[RANK_MAX][UNITNAME_MAX+1],
   char new_sort[RANK_MAX][DEFNNAME_MAX+1])
;
int cdds_newcube(
   char order[],
   int *old_rank,
   int old_size[RANK_MAX],
   float old_origin[RANK_MAX],
   float old_delta[RANK_MAX],
   float old_base[RANK_MAX],
   float old_step[RANK_MAX],
   char old_axis[RANK_MAX][AXISNAME_MAX+1],
   char old_unit[RANK_MAX][UNITNAME_MAX+1],
   char old_sort[RANK_MAX][DEFNNAME_MAX+1])
;


int cdds_scanf(
   const char *alias,
   const char *fmt,
   ...)
;
const char * cdds_scanq(
   const char *str)
;
int cdds_printf(
   const char *name,
   const char *fmt,
   ...)
;
int cdds_printq(
   const char *buf)
;
int cdds_key(
   const char *alias)
;


const char * cdds_datadefn(
   const char *data_dict,
   const char *data_alias)
;
const char * cdds_dataname(
   const char *path_name,
   const char *base_name,
   const char *suffix)
;


BIN_TAG cdds_open(
   const char *in_dict,
   const char *format_alias,
   const char *data_alias,
   const char *mode)
;
int cdds_close(
   BIN_TAG bin_tag)
;
TYPE_TAG cdds_target(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag)
;
int cdds_read(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag,
   void *buf,
   int count)
;
int cdds_readm(
   BIN_TAG in_bin_tag,
   TYPE_TAG in_type,
   BIN_TAG out_bin_tag,
   TYPE_TAG out_type,
   void *out_buf,
   int count)
;
int cdds_write(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag,
   const void *buf,
   int count)
;
int cdds_writem(
   BIN_TAG out_bin_tag,
   TYPE_TAG out_type,
   BIN_TAG in_bin_tag,
   TYPE_TAG in_type,
   void *in_buf,
   int count)
;
long cdds_lseek(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag,
   long position,
   int whence)
;
HUGE_OFFSET cdds_lseek8(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag,
   HUGE_OFFSET offset,
   int whence)
;
int cdds_map(
   BIN_TAG out_bin_tag,
   TYPE_TAG out_type_tag,
   void *out_buf,
   BIN_TAG in_bin_tag,
   TYPE_TAG in_type_tag,
   const void *in_buf)
;


const char * cdds_mapdefn(
   const char *in_format,
   const char *out_format,
   const char *out_field)
;
const char * cdds_mapalias(
   const char *altformat,
   const char *in_format,
   const char *out_format,
   const char *out_field)
;


int cdds_offset(
   BIN_TAG bin_tag,
   const char *type_name,
   const char *field_name,
   const char *prime_name)
;
int cdds_index(
   BIN_TAG bin_tag,
   const char *type_name,
   const char *field_name,
   const char *prime_name)
;
int cdds_count(
   BIN_TAG bin_tag,
   const char *type_name,
   const char *field_name)
;
int cdds_domain(
   BIN_TAG bin_tag,
   int rank)
;
int cdds_axis_prod(
   int rank)
;
int cdds_size(
   BIN_TAG bin_tag,
   const char *type_name,
   const char *field_name)
;
const char * cdds_note(
   BIN_TAG bin_tag,
   const char *type_name,
   const char *field_name)
;
const char * cdds_genus(
   BIN_TAG bin_tag,
   const char *type_name,
   const char *field_name)
;
int cdds_align(
   BIN_TAG bin_tag,
   const char *type_name,
   const char *field_name)
;
int cdds_prec(
   BIN_TAG bin_tag,
   const char *type_name,
   const char *field_name)
;
TYPE_TAG cdds_prime(
   BIN_TAG bin_tag,
   const char *type_name,
   const char *field_name)
;
int cdds_tags(
   BIN_TAG bin_tag,
   const char *type_name,
   const char *field_name)
;
TYPE_TAG cdds_type(
   BIN_TAG bin_tag,
   const char *type_name,
   const char *field_name)
;


FIELD_TAG cdds_field(
   BIN_TAG bin_tag,
   const char *type_name,
   const char *field_name)
;
const char * cdds_name(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag)
;


int cdds_get(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   const void *in_buf,
   char *out_array,
   int array_n)
;
int cdds_getcs(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   const void *in_buf,
   char *out_array,
   int array_n)
;
int cdds_getcb(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   const void *in_buf,
   char *out_array,
   int array_n)
;
int cdds_geti(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   const void *in_buf,
   int *out_array,
   int array_n)
;
int cdds_gets(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   const void *in_buf,
   short int *out_array,
   int array_n)
;
int cdds_getl(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   const void *in_buf,
   long int *out_array,
   int array_n)
;
int cdds_getu(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   const void *in_buf,
   unsigned *out_array,
   int array_n)
;
int cdds_getus(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   const void *in_buf,
   short unsigned *out_array,
   int array_n)
;
int cdds_getf(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   const void *in_buf,
   float *out_array,
   int array_n)
;
int cdds_getd(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   const void *in_buf,
   double *out_array,
   int array_n)
;
int cdds_getld(
   BIN_TAG bin_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   const void *in_buf,
   LONG_DOUBLE_OK *out_array,
   int array_n)
;


int cdds_put(
   BIN_TAG out_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   void *out_buf,
   const char *in_array,
   int array_n)
;
int cdds_putcs(
   BIN_TAG out_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   void *out_buf,
   const char *in_array,
   int array_n)
;
int cdds_putcb(
   BIN_TAG out_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   void *out_buf,
   const char *in_array,
   int array_n)
;
int cdds_puti(
   BIN_TAG out_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   void *out_buf,
   const int *in_array,
   int array_n)
;
int cdds_puts(
   BIN_TAG out_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   void *out_buf,
   const short int *in_array,
   int array_n)
;
int cdds_putl(
   BIN_TAG out_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   void *out_buf,
   const long int *in_array,
   int array_n)
;
int cdds_putu(
   BIN_TAG out_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   void *out_buf,
   const unsigned *in_array,
   int array_n)
;
int cdds_putus(
   BIN_TAG out_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   void *out_buf,
   const short unsigned *in_array,
   int array_n)
;
int cdds_putf(
   BIN_TAG out_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   void *out_buf,
   const float *in_array,
   int array_n)
;
int cdds_putd(
   BIN_TAG out_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   void *out_buf,
   const double *in_array,
   int array_n)
;
int cdds_putld(
   BIN_TAG out_tag,
   TYPE_TAG type_tag,
   FIELD_TAG field_tag,
   void *out_buf,
   const LONG_DOUBLE_OK *in_array,
   int array_n)
;


void * cdds_malloc(
   size_t size)
;
void * cdds_realloc(
   void * ptr,
   size_t size)
;
void * cdds_calloc(
   size_t nobj,
   size_t size)
;
void cdds_free(
   void * ptr)
;


char *cdds_toebcdic(
   char *dest,
   const char *source,
   int count)
;
char *cdds_toascii(
   char *dest,
   const char *source,
   int count)
;


TIME_TAG cdds_timeslot(
   const char *name)
;
int cdds_timedump(
   TIME_TAG tag)
;
double cdds_timerest(
   TIME_TAG tag)
;
double cdds_timestrt(
   TIME_TAG tag)
;
double cdds_timestop(
   TIME_TAG tag)
;


int cdds_binvds(
   const char *in_dict,
   const DISCO_HEADER *disco_header)
;
const DISCO_HEADER * cdds_vdsbin(
   BIN_TAG bin_tag)
;

#else
/* old style function declaration */

int cdds_dict();
int cdds_extend();
int cdds_copy();
int cdds_history();
int cdds_copyhist();
char * cdds_in();
char * cdds_out();
char * cdds_mod();

int cdds_incube();
int cdds_outcube();
int cdds_newcube();

int cdds_scanf();
char * cdds_scanq();
int cdds_printf();
char * cdds_printq();
int cdds_key();

char * cdds_datadefn();
char * cdds_dataname();

BIN_TAG cdds_open();
int cdds_close();
TYPE_TAG cdds_target();
int cdds_read();
int cdds_readm();
int cdds_write();
int cdds_writem();
long cdds_lseek();
int cdds_map();

char * cdds_mapdefn();
char * cdds_mapalias();

int cdds_offset();
int cdds_index();
int cdds_count();
int cdds_domain();
int cdds_size();
char * cdds_note();
char * cdds_genus();
int cdds_align();
int cdds_prec();
TYPE_TAG cdds_prime();
int cdds_tags();

FIELD_TAG cdds_field();
TYPE_TAG cdds_type();
char * cdds_name();

int cdds_defnvds();

int cdds_get();
int cdds_getcs();
int cdds_getcb();
int cdds_geti();
int cdds_gets();
int cdds_getl();
int cdds_getu();
int cdds_getus();
int cdds_getul();
int cdds_getf();
int cdds_getd();
int cdds_getld();

int cdds_put();
int cdds_putcs();
int cdds_putcb();
int cdds_puti();
int cdds_puts();
int cdds_putl();
int cdds_putu();
int cdds_putus();
int cdds_putul();
int cdds_putf();
int cdds_putd();
int cdds_putld();

char *cdds_malloc();
char *cdds_realloc();
char *cdds_calloc();
int cdds_free();

char *cdds_toebcdic();
char *cdds_toascii();

int setargcv();

TIME_TAG cdds_timeslot();
int cdds_timedump();
double cdds_timerest();
double cdds_timestrt();
double cdds_timestop();

#endif

#ifdef  __cplusplus
}
#endif

#endif /* #ifndef __cdds_h */
