/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <localsys.h>

      integer SZDTHD, SZTRHD, SZSAMP, SZSMPM, SZLNHD, SZSPRD
      integer SZDVHD,SZVAHD,LNTRHD,SZINPH
      integer SZSMPD, HSTOFF, SZHFWD
      integer VDVOFF
      integer ITRWRD, ITHWP1, ISZBYT
c-----
c      SZDTHD	- size of trace header on disk in bytes
c      SZINPH   - size integer trace plus header
c      SZTRHD	- size of trace header in pipes in bytes
c      LNTRHD   - size of trace header in samples
c      SZDVHD	- size of vanl analysis header on disk in bytes
c      SZVAHD	- size of vanl analysis header in pipes in bytes
c      SZSAMP	- size of floating point sample in bytes
c      SZSMPM	- maximum number of trace samples
c      SZLNHD	- line file size = (SZTRHD + SZSAMP*MAXSMP)/2
c      SZSPRD   - size of the spread in channels
c      SZSMPD   - size of sample in pipe (in bytes)
c      HSTOFF   - byte count at which hlh starts
c      VDVOFF   - byte count at which v-dv pairs start in vanl format data
c      SZHFWD   - size in bytes of 1/2 word
c      ITRWRD   - number of full words (memory) in trace header
c      ITHWP1   - ITRWRD + 1
c      ISZBYT   - number of bytes in a word (memory) for this system
c-----
      parameter (SZDTHD=256, LNTRHD=128)
      parameter (SZDVHD=2112)
      parameter (SZSAMP=4, SZLNHD=10000)

#ifndef CRAYSYSTEM
      parameter (SZTRHD=256, SZSMPD=4,SZSMPM=4096,SZINPH=4128)
      parameter (SZVAHD=2112)
      parameter (SZSPRD=1000, HSTOFF=1004)
      parameter (VDVOFF=64)
      parameter (SZHFWD=2)
      parameter (ITRWRD = 64, ISZBYT = 4)
      parameter (ITHWP1 = 65)
#else
      parameter (SZTRHD=1024, SZSMPD=8,SZSMPM=8192,SZINPH=8320)
      parameter (SZVAHD=4272)
      parameter (SZSPRD=1500, HSTOFF=2592)
      parameter (VDVOFF=176)
      parameter (SZHFWD=8)
      parameter (ITRWRD = 128, ISZBYT = 8)
      parameter (ITHWP1 = 129)
#endif
