/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef _IoDefs_h   
#define _IoDefs_h

#include <localsys.h>

#ifndef C_COMMENTS_DISALLOWED
/* define the Fortran entry point names */
#endif

#undef HOST_FTN_FUNC
#undef USP_C_FUNC

#ifdef FTN_TO_C_UPPERCASE
#ifndef C_COMMENTS_DISALLOWED
/***************************************************************/
/* 15 July 1998, Randy Selzler, added macro for C/Fortran API. */
/* C Usage: HOST_FTN_FUNC(rtape, RTAPE)(lunit, buffer, length) */
/***************************************************************/
#endif
#define HOST_FTN_FUNC(lname, uname) uname

#define F_BKSPT BKSPT
#define F_LBCLOS LBCLOS
#define F_LBOPEN LBOPEN
#define F_LUCFD LUCFD
#define F_RTAPE RTAPE
#define F_RWD RWD
#define F_SEEKT SEEKT
#define F_SISABORT SISABORT
#define F_SISB4MSG SISB4MSG
#define F_SISERROR SISERROR
#define F_SISFDFIT SISFDFIT
#define F_SISFMT SISFMT
#define F_SISINFO SISINFO
#define F_SISLGBUF SISLGBUF
#define F_SISPRT SISPRT
#define F_SISSEEK SISSEEK
#define F_SISVER SISVER
#define F_SKIPT SKIPT
#define F_WRTAPE WRTAPE
#endif

#ifdef FTN_TO_C_UNDERSCORE_SUFFIX
#ifndef C_COMMENTS_DISALLOWED
/***************************************************************/
/* 15 July 1998, Randy Selzler, added macro for C/Fortran API. */
/* C Usage: HOST_FTN_FUNC(rtape, RTAPE)(lunit, buffer, length) */
/***************************************************************/
#endif
#define HOST_FTN_FUNC(lname, uname) lname ## _

#define F_BKSPT bkspt_
#define F_LBCLOS lbclos_
#define F_LBOPEN lbopen_
#define F_LUCFD lucfd_
#define F_RTAPE rtape_
#define F_RTAPE4 rtape4_
#define F_RWD rwd_
#define F_SEEKT seekt_
#define F_SISABORT sisabort_
#define F_SISB4MSG sisb4msg_
#define F_SISERROR siserror_
#define F_SISFDFIT sisfdfit_
#define F_SISFMT sisfmt_
#define F_SISINFO sisinfo_
#define F_SISLGBUF sislgbuf_
#define F_SISPRT sisprt_
#define F_SISSEEK sisseek_
#define F_SISVER sisver_
#define F_SISWHEN siswhen_
#define F_SKIPT skipt_
#define F_WRTAPE wrtape_
#endif

#ifdef FTN_TO_C_NAME_COMPATABILITY
#ifndef C_COMMENTS_DISALLOWED
/***************************************************************/
/* 15 July 1998, Randy Selzler, added macro for C/Fortran API. */
/* C Usage: HOST_FTN_FUNC(rtape, RTAPE)(lunit, buffer, length) */
/***************************************************************/
#endif
#define HOST_FTN_FUNC(lname, uname) lname

#define F_BKSPT bkspt
#define F_LBCLOS lbclos
#define F_LBOPEN lbopen
#define F_LUCFD lucfd
#define F_RTAPE rtape
#define F_RWD rwd
#define F_SISABORT sisabort
#define F_SISB4MSG sisb4msg
#define F_SISERROR siserror
#define F_SISFDFIT sisfdfit
#define F_SISFMT sisfmt
#define F_SISINFO sisinfo
#define F_SISLGBUF sislgbuf
#define F_SISPRT sisprt
#define F_SISSEEK sisseek
#define F_SISTRACE sistrace
#define F_SISVER sisver
#define F_SISWHEN siswhen
#define F_SKIPT skipt
#define F_WRTAPE wrtape
#endif

#ifndef C_COMMENTS_DISALLOWED
/* define the C entry point names */
#endif

#ifdef FTN_TO_C_NAME_COMPATABILITY
#ifndef C_COMMENTS_DISALLOWED
/***************************************************************/
/* 15 July 1998, Randy Selzler, added macro for C/Fortran API. */
/* C Usage: USP_C_FUNC(rtape)(lunit, buffer, length)           */
/***************************************************************/
#endif
#define USP_C_FUNC(name)   name ## _c

#define C_BKSPT bkspt_c
#define C_LBCLOS lbclos_c
#define C_LBOPEN lbopen_c
#define C_LUCFD lucfd_c
#define C_RTAPE rtape_c
#define C_RWD rwd_c
#define C_SISABORT sisabort_c
#define C_SISB4MSG sisb4msg_c
#define C_SISERROR siserror_c
#define C_SISFDFIT sisfdfit_c
#define C_SISFMT sisfmt_c
#define C_SISINFO sisinfo_c
#define C_SISLGBUF sislgbuf_c
#define C_SISPRT sisprt_c
#define C_SISSEEK sisseek_c
#define C_SISTRACE sistrace_c
#define C_SISVER sisver_c
#define C_SISWHEN siswhen_c
#define C_SKIPT skipt_c
#define C_WRTAPE wrtape_c
#else
#ifndef C_COMMENTS_DISALLOWED
/***************************************************************/
/* 15 July 1998, Randy Selzler, added macro for C/Fortran API. */
/* C Usage: USP_C_FUNC(rtape)(lunit, buffer, length)           */
/***************************************************************/
#endif
#define USP_C_FUNC(name)   name

#define C_BKSPT bkspt
#define C_LBCLOS lbclos
#define C_LBOPEN lbopen
#define C_LUCFD lucfd
#define C_RTAPE rtape
#define C_RWD rwd
#define C_SISABORT sisabort
#define C_SISB4MSG sisb4msg
#define C_SISERROR siserror
#define C_SISFDFIT sisfdfit
#define C_SISFMT sisfmt
#define C_SISINFO sisinfo
#define C_SISLGBUF sislgbuf
#define C_SISPRT sisprt
#define C_SISSEEK sisseek
#define C_SISTRACE sistrace
#define C_SISVER sisver
#define C_SISWHEN siswhen
#define C_SKIPT skipt
#define C_WRTAPE wrtape
#endif

#ifdef _NO_PROTO
    extern void F_BKSPT();
    extern void F_LBCLOS();
    extern void F_LBOPEN();
    extern void F_RTAPE();
    extern void F_RWD();
    extern void F_SEEKT();
    extern void F_SISABORT();
    extern void F_SISB4MSG();
    extern void F_SISERROR();
    extern void F_SISFDFIT();
    extern void F_SISFMT();
    extern void F_SISINFO();
    extern void F_SISLGBUF();
    extern void F_SISPRT();
    extern void F_SISSEEK();
    extern void F_SISVER();
    extern void F_SISWHEN();
    extern void F_SKIPT();
    extern void F_WRTAPE();

    extern void C_BKSPT();
    extern void C_LBCLOS();
    extern void C_LBOPEN();
    extern void C_RTAPE();
    extern void C_RWD();
    extern void C_SISABORT();
    extern void C_SISB4MSG();
    extern void C_SISERROR();
    extern void C_SISFDFIT();
    extern void C_SISFMT();
    extern void C_SISINFO();
    extern void C_SISLGBUF();
    extern void C_SISPRT();
    extern void C_SISSEEK();
    extern void C_SISTRACE();
    extern void C_SISVER();
    extern void C_SISWHEN();
    extern void C_SKIPT();
    extern void C_WRTAPE();
#else
#if defined(__cplusplus) || defined(c_plusplus)		/* C++ Prototype Only */
    extern "C" {
#endif
    extern void C_BKSPT( int, int );
    extern void C_LBCLOS( int );
    extern void C_LBOPEN( int *, char *, char * );
    extern void C_RTAPE( int, char *, int * );
    extern void C_RWD( int );
    extern void C_SEEKT( int, int );
    extern void C_SISABORT( int, char * );
    extern void C_SISB4MSG( char * );
    extern void C_SISERROR( int, int * );
    extern void C_SISFDFIT( int *, int );
    extern void C_SISFMT( int, char * );
    extern void C_SISINFO( int, int * );
    extern void C_SISLGBUF( int, char * );
    extern void C_SISPRT( int );
    extern void C_SISSEEK( int, int );
    extern void C_SISVER( );
    extern void C_SKIPT( int, int );
    extern void C_WRTAPE( int, char *, int );

#if defined(__cplusplus) || defined(c_plusplus)		/* C++ Prototype Only */
}
#endif

#endif	/* End of ANSI C or C++ function prototypes. */

#endif
