/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

/*
 *	Module	:	s_globals.h
 *	Date	:	8709.20
 *	Author	:	D. Mears
 *	Purpose	:	Include file for seismic workstation globals.
 *
 *	$Log:	s_globals.h,v $
 * Revision 1.7  89/01/06  11:41:52  james
 * New features were added:  the pick bias feature and the pick label name.
 * The host and server options on the panel were changed.
 * 
 * Revision 1.6  88/10/07  13:07:10  james
 * Newcolor: dwm+james changes for color / remove sb.
 * 
 * Revision 1.3  88/10/05  13:48:34  dwm
 * Autopick: Provide automatic pick generation.
 * 
 * Revision 1.1  88/09/27  15:56:28  dwm
 * Initial revision
 * 
 *	Make emess larger so that long file names don't overflow.
 *	Added cmd_txt, cmd_file_txt panel entries, and cmd_getseisname.  
 *	Change default max and min colors to be compatible with 
 *		monochrome.
 *		03/03/88 - dwm.
 */

#include	<suntool/sunview.h>
#include	<suntool/canvas.h>
#include	<suntool/panel.h>
#include	"cms_parms.h"
 
/* Cms_parms.h defines the two parameters S_CMS_START and S_CMS_LENGTH. */


#define OSTATUS1(a,b) {sprintf(ostatus, a, b); \
			window_set(frame, FRAME_LABEL, ostatus,0);}
#define OSTATUS2(a,b,c) {sprintf(ostatus, a, b, c); \
			window_set(frame, FRAME_LABEL, ostatus, 0);}
#define OSTATUS3(a,b,c,d) {sprintf(ostatus, a, b, c, d); \
			window_set(frame, FRAME_LABEL, ostatus, 0);}
#define OSTATUS4(a,b,c,d,e) {sprintf(ostatus, a, b, c, d, e); \
			window_set(frame, FRAME_LABEL, ostatus, 0);}
extern	char	*sys_errlist[];


#define	NSEIS_WDOWS	50

typedef	
struct	s_displaylist {
	enum	s_dtype {S_NOTE, S_MAGNIFIER} s_d;
	struct	s_displaylist *next;
	union {
		struct	s_note {
			int	s_x, s_y;
			char	*s_ch;
		} s_n;
		struct	s_magnifier {
			int	s_x0, s_y0, s_x1, s_y1;
			int	s_windno;
		} s_m;
	} s_dt;
} DLIST;

typedef
struct	s_image {
	int	ct;
	int	linebytes;
	char	*img;
	} IMAGE;

typedef
struct	seis	{
	int	s_used:1;		/* this entry in use */
	int	s_shown:1;		/* this canvas has been shown  */
	int	s_spare:6;		/* spare flags */
	Frame	s_f;
	Canvas	s_c;
	Pixwin	*s_pw;
	Pixrect	*s_pxr;
	enum	axis s_xyaxis;
	int 	s_can_w, s_can_h;	/* canvas dimensions */
	int	s_frm_w, s_frm_h;	/* window dimensions */ 
	int	s_xmin, s_xmax;		/* max and min values for draw_grid() */
	int	s_ymin, s_ymax;
	int	s_rstart, s_rend, s_rskip;
	int	s_tstart, s_tend, s_tskip;
	int	s_sstart, s_send, s_sskip;
	int	s_xzoom, s_yzoom;
	float	s_xscale,s_yscale;	/* scale = zoom / skips
					 * 3d scale = zoom  
					 */
	short	s_segno; 		/* segment no. at window creation */
	short	s_exposure; 		/* exposure index for poaching */
	char	s_fname[80];
	float	s_gain;
	int	s_bias;
	float	s_rec_units;
	float	s_trac_units;
	float	s_samp_units;
	int	s_grid_on;
	float	s_x_grid;
	float	s_y_grid;
	float	s_x_units;
	float	s_y_units;
	char	s_tlabel[128];
	long	s_imagef_addr;
	int	s_pix_hist;
	DLIST	*s_dl;
	IMAGE	*s_img;			/* used for bitmap magnify only */
	char	s_cmsname[64];
	int	s_img_offset;		/* used for bitmap magnify only */
}	SEISW;


extern	SEISW	*seisw_frame(), *seisw_canvas(), *seisw_empty(), *seisw_index();
extern	SEISW 	*seisw_pw();

#define	S_MIN_COLOR	1			/* minimum color */
#define	S_MAX_COLOR	S_CMS_END-S_CMS_START+1	/* max color */

#define S_BACKGROUND	S_CMS_START 		/* white background */
#define S_WHITE		S_CMS_START 		/* white background */
#define	S_GRD_COLOR	S_CMS_END+2		/* gray grid lines */ 
#define	S_PKX_COLOR 	S_CMS_END+3		/* test pick color */
#define	S_CUR_COLOR	S_CMS_END+4		/* blue cursor */
#define	S_PK1_COLOR	S_CMS_END+5		/* accepted pick color*/
#define	S_PK2_COLOR	S_CMS_END+6		/* accepted pick color*/
#define	S_PK3_COLOR	S_CMS_END+7		/* accepted pick color*/
#define	S_PK4_COLOR	S_CMS_END+8		/* accepted pick color*/
#define	S_PK5_COLOR	S_CMS_END+9		/* accepted pick color*/
#define	S_PK6_COLOR	S_CMS_END+10		/* accepted pick color*/
#define	S_PK7_COLOR	S_CMS_END+11		/* accepted pick color*/
#define	S_PK8_COLOR	S_CMS_END+12		/* accepted pick color*/
#define	S_FOREGROUND	S_CMS_END+13		/* black foreground */
#define	S_BLACK		S_CMS_END+13		/* black foreground */

/* if the server names are changed, fix the special kludge in s_defaults.c */
#define CRAY32SERVER	"isis20"
#define SUNSERVER	"sunsis20"
#define SHARED_MEM		/* Use shared memory for edlut */

#ifdef INIT
char    *s_background	= "255 255 255       "; /* white background */
char	*s_foreground 	= "000 000 000       ";	/* foreground */
char	*s_cur_color 	= "000 000 255       ";	/* blue cursor */
char	*s_grd_color 	= "150 150 255       ";	/* light blue grid lines */ 
char	*s_pkx_color 	= "255 000 000       ";	/* test pick color */
char	*s_pk1_color 	= "000 255 000       ";	/* accepted pick color */	
char	*s_pk2_color 	= "000 236 255       ";	/* accepted pick color */	
char	*s_pk3_color 	= "000 000 255       ";	/* accepted pick color */	
char	*s_pk4_color 	= "255 200 245       ";	/* accepted pick color */	
char	*s_pk5_color 	= "255 200 200       ";	/* accepted pick color */	
char	*s_pk6_color 	= "255 160 000       ";	/* accepted pick color */	
char	*s_pk7_color 	= "255 255 000       ";	/* accepted pick color */	
char	*s_pk8_color 	= "190 255 000       ";	/* accepted pick color */	
char	*s_unused_color	= "255 100 255       ";	/* unused color */	
char	*s_black 	= "000 000 000       ";	/* black */
char	*s_white 	= "255 255 255       ";	/* white */
char	*s_min_color 	= "255 255 255       ";	/* minimum color */
char	*s_max_color 	= "000 000 000       ";	/* max color */
char	*xname[] = {"traces", "records", "traces", "records", 
			"traces"};
char	*yname[] = {"samples", "samples", "records", "samples", "samples"};
char	*sserver	=	CRAY32SERVER;
int	seisfile_open = 0;			/* file is open flag */
int	sfp = -1;
float	rec_units = 1.0, trac_units = 1.0,  samp_units = 1.0;
int	spare_files = 7;			/* Spare files needed =
						   2 for sunview, 
						   2 for rsh pipes,
						   1 for image file */
#else
char    *s_background; 				/* white background */
char	*s_foreground;				/* foreground */
char	*s_cur_color;				/* blue cursor */
char	*s_grd_color;				/* gray grid lines */ 
char	*s_pkx_color;				/* test pick color */
char	*s_pk1_color;				/* accepted pick color */	
char	*s_pk2_color;				/* accepted pick color */	
char	*s_pk3_color;				/* accepted pick color */	
char	*s_pk4_color;				/* accepted pick color */	
char	*s_pk5_color;				/* accepted pick color */	
char	*s_pk6_color;				/* accepted pick color */	
char	*s_pk7_color;				/* accepted pick color */	
char	*s_pk8_color;				/* accepted pick color */	
char	*s_black;				/* black */
char	*s_white;				/* white */
char	*s_min_color;				/* minimum color */
char	*s_max_color;				/* max color */
char	*xname[];
char	*yname[];
char	*sserver;
float	rec_units, trac_units,  samp_units;
int	sfp;
int	seisfile_open;
int	spare_files;
#endif
char 	*login;	  	/* cray login rsh is done to */
char	*host;
char	emess[256];	/* allow long file names to be used */


#ifdef lint
PALETTE palette;
#else 
PALETTE	*palette;
#endif
char	paletteid[20];	/* shared memory id of palette in ascii */
SEIS_HEAD	shdr;
char	*program;	/* program name */
int	flagm;		/* -m monochrome flag */
int	flagF;		/* -F use file flag */
int	imbed_wait;
char	ostatus[256];	/* Panel status message */
Frame	xframe;		/* Extra frame */
Panel	xpanel;		/* Extra panel */
Frame	frame;
Panel	panel;
Panel_item	host_opt, draw_but, connect_but, redraw_but, login_txt;
Panel_item	seisname_txt, grid_opt, three_d_opt;
Panel_item	save_selects_opt;
Panel_item	cmd_files_txt, cmd_txt;
Panel_item	err_mess, rec_txt;
Panel_item	wiggles_opt, wiggle_ovlp_txt, wiggle_skip_txt, wiggle_gain_txt;
Panel_item 	imbed_note_opt;
Panel_item	trac_txt, samp_txt, gain_txt, lut_txt, lut_bin_opt, pick_txt; 
Panel_item	pick_auto_opt, window_size_txt, pick_inc_txt;
Panel_item	x_grid_txt, y_grid_txt;
Panel_item	imbednote_txt, expose_opt;
Panel_item	xzm_sld, yzm_sld;
Panel_item	recunit_txt, trunit_txt, smunit_txt;
Panel_item	bias_sld, label_opt, label_name_txt; 
Panel_item	pick_bias_txt, pick_bias_opt;
Panel_item	pick_r_but, pick_w_but, pick_e_but;
Panel_item	pix_hist_opt, gain_c_mess;
Panel_item 	image_txt, zoom_opt;
Panel_item	def_txt, wdef_but, rdef_but, server_txt; 
Panel_item 	col_mess, fc_txt, bc_txt, gc_txt, cc_txt, tc_txt;
Panel_item	pc_opt, pc1_txt, pc2_txt,  pc3_txt,  pc4_txt,  pc5_txt; 
Panel_item	pc6_txt,  pc7_txt,  pc8_txt; 

SEISW	*last_tsw;

int	S_Cms_Length;			/* These are the global variables */
int	S_Cms_Start;			/* for the cms parameters.        */
int	S_Cms_End;
int     S_Max_Color;
int     S_Min_Color;
int     S_Background;           /* white background */
int     S_White     ;           /* white background */
int     S_Grd_Color ;           /* gray grid lines */
int     S_Pkx_Color ;           /* test pick color */
int     S_Cur_Color ;           /* blue cursor */
int     S_Pk1_Color ;           /* accepted pick color*/
int     S_Pk2_Color ;           /* accepted pick color*/
int     S_Pk3_Color ;           /* accepted pick color*/
int     S_Pk4_Color ;           /* accepted pick color*/
int     S_Pk5_Color ;           /* accepted pick color*/
int     S_Pk6_Color ;           /* accepted pick color*/
int     S_Pk7_Color ;           /* accepted pick color*/
int     S_Pk8_Color ;           /* accepted pick color*/
int     S_Foreground;           /* black foreground */
int     S_Black    ;

/*  max_color and min_color are shared with the adjust_color function. */
int     max_color;
int	min_color;

int	debug;				/* debug flag */
int	windowno;
int	segno;				/* current segment number */
int	exposure;			/* current exposure (for poaching ) */
int	max_windows;			/* max active seismic windows */
int	active_windows;			/* number of active windows */
char	cms_name[64];			/* color map name */

char * sprintf();			/* kludge for lint -- not in stdio.h*/

char * cmd_get_seisname();
