/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef _SaveDefs_h
#define _SaveDefs_h

#include <ut_defs.h>
 
#ifndef C_COMMENTS_DISALLOWED
/*
   These constants are used within the save(3) codes. See the manual
   page for a particular subroutine for usage.
						- Joe M. Wade 



   Added definition for floating values which are actually shared across
   two half-word locations. These will be split out into the bottom sections
   of two integers after translation so Cray format. I call these "fake floats"
   and the define'd code is SAVE_FKFLT_DEF.
					 - joe m. wade  4/14/95

   Use of name SAVE_LONG_DEF is historical. It actually refers to ints 
   on the Cray.
*/
#endif

#define READHEADER 0
#define WRITEHEADER 1

#define	LINEHEADER 0
#define	TRACEHEADER 1
#define	VANLHEADER 2
#define	VSPNHEADER 3
#define	SEGYLINEHEADER 4
#define	SEGYTRACEHEADER 5

#define SAVE_CHAR_DEF		3
#define SAVE_SHORT_DEF		4
#define SAVE_INT_DEF		1
#define SAVE_LONG_DEF		1
#define SAVE_FLOAT_DEF		2
#define SAVE_FKFLT_DEF		5 
#define SAVE_DUMMY_DEF		6 

#define SAVE_CHARACTER_DEF	SAVE_CHAR_DEF
#define SAVE_INTEGER_DEF	SAVE_LONG_DEF
#define SAVE_INTEGER_2_DEF	SAVE_SHORT_DEF
#define SAVE_INTEGER2_DEF	SAVE_SHORT_DEF
#define SAVE_REAL_DEF		SAVE_FLOAT_DEF
#define SAVE_FAKE_REAL_DEF	SAVE_FKFLT_DEF

#endif	/* _SaveDefs_h */
