/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef _SegySaveDefs_h
#define _SegySaveDefs_h

#define SEGYEBCDICHEADERBYTES 3200
#define SEGYLINEHEADERBYTES 400
#define SEGYTRACEHEADERBYTES 240

#include <save_defs.h>

static struct hdr segy_lhdr[] = {
  {"JobNum",       SAVE_LONG_DEF,   0,   1, " Job Identification Number " },
  {"LineNum",      SAVE_LONG_DEF,   1,   1, " Line Number " },
  {"ReelNum",      SAVE_LONG_DEF,   2,   1, " Reel Number " },
  {"NumTrc",       SAVE_SHORT_DEF,  6,   1, " Data traces per record " },
  {"NumAux",       SAVE_SHORT_DEF,  7,   1, " Auxiliary traces per record " },
  {"SmpInt",       SAVE_SHORT_DEF,  8,   1, " Sample Interval in microsecs " },
  {"OrigSmpInt",   SAVE_SHORT_DEF,  9,   1, " Orig. Sample Interval in microsecs" },
  {"NumSmp",       SAVE_SHORT_DEF, 10,   1, " Samples per trace on this reel" },
  {"OrigNumSmp",   SAVE_SHORT_DEF, 11,   1, " Original samples per trace " },
  {"FmtCode",      SAVE_SHORT_DEF, 12,   1, " Sample Format Code " },
  {"CdpFold",      SAVE_SHORT_DEF, 13,   1, " CDP fold " },
  {"SortCode",     SAVE_SHORT_DEF, 14,   1, " Trace Sorting Code " },
  {"VertSumFlag",  SAVE_SHORT_DEF, 15,   1, " Vertical Sum Code " },
  {"SwpFreqStart", SAVE_SHORT_DEF, 16,   1, " Sweep Frequency at Start " },
  {"SwpFreqEnd",   SAVE_SHORT_DEF, 17,   1, " Sweep Frequency at End " },
  {"SwpLength",    SAVE_SHORT_DEF, 18,   1, " Sweep Length " },
  {"SwpCode",      SAVE_SHORT_DEF, 19,   1, " Sweep Type Code " },
  {"SwpChan",      SAVE_SHORT_DEF, 20,   1, " Trace Number of Sweep Channel " },
  {"SwpTprStart",  SAVE_SHORT_DEF, 21,   1, " Sweep Trace Taper Length @ Start" },
  {"SwpTprEnd",    SAVE_SHORT_DEF, 22,   1, " Sweep Trace Taper Length @ End" },
  {"SwpTprType",   SAVE_SHORT_DEF, 23,   1, " Taper Type " },
  {"CorrFlag",     SAVE_SHORT_DEF, 24,   1, " Correlated Data Traces " },
  {"GainFlag",     SAVE_SHORT_DEF, 25,   1, " Binary Gain Recovered " },
  {"AmpFlag",      SAVE_SHORT_DEF, 26,   1, " Amplitude Recover Method " },
  {"UnitsFlag",    SAVE_SHORT_DEF, 27,   1, " Measurement System " },
  {"PolarityFlag", SAVE_SHORT_DEF, 28,   1, " Impulse Signal Polarity " },
  {"VibLagFlag",   SAVE_SHORT_DEF, 29,   1, " Vibratory Polarity Code " },
  {"SpareBinI2",   SAVE_SHORT_DEF, 30, 170, " unassigned " },
  {"SpareBinI4",   SAVE_LONG_DEF,  15,  85, " unassigned " },
  {"SpareBinF4",   SAVE_FLOAT_DEF, 15,  85, " unassigned " },
  {"SpareBinF4ibm",SAVE_FLOAT_DEF, 15,  85, " unassigned " },
  {(char *)0,		 -1,  -1, -1, " end of list			" }
  } ;

static struct hdr segy_thdr[] = {
  {"LineTrcNum",     SAVE_LONG_DEF,   0,  1, " Trace Seq Number within Line " },
  {"ReelTrcNum",     SAVE_LONG_DEF,   1,  1, " Trace Seq Number within Reel " },
  {"FieldRecNum",    SAVE_LONG_DEF,   2,  1, " Original Field Record Number " },
  {"FieldTrcNum",    SAVE_LONG_DEF,   3,  1, " Trace No. within Orig Record " },
  {"SrcPtNum",       SAVE_LONG_DEF,   4,  1, " Energy Source Point Number " },
  {"CdpNum",         SAVE_LONG_DEF,   5,  1, " CDP Ensemble Number " },
  {"CdpTrcNum",      SAVE_LONG_DEF,   6,  1, " Trace No. Within CDP Ensemble" },
  {"TrcIdCode",      SAVE_SHORT_DEF, 14,  1, " Trace Identification Code " },
  {"VertStack",      SAVE_SHORT_DEF, 15,  1, " Number of Vertically Summed Traces Yielding this Trace " },
  {"HorzStack",      SAVE_SHORT_DEF, 16,  1, " Number of Horizontally Stacked Traces Yielding this Trace " },
  {"DataUse",        SAVE_SHORT_DEF, 17,  1, " Data Use: 1=prod 2=test " },
  {"DstSgn",         SAVE_LONG_DEF,   9,  1, " Distance from Source to Receiver " },
  {"GrpElev",        SAVE_LONG_DEF,  10,  1, " Receiver Group Elevation " },
  {"SrcElev",        SAVE_LONG_DEF,  11,  1, " Surface Elevation at Source " },
  {"SrcDepth",       SAVE_LONG_DEF,  12,  1, " Source Depth Below Surface " },
  {"GrpDatum",       SAVE_LONG_DEF,  13,  1, " Datum Elevation At Receiver Group " },
  {"SrcDatum",       SAVE_LONG_DEF,  14,  1, " Datum Elevation At Source " },
  {"WatDepthSrc",    SAVE_LONG_DEF,  15,  1, " Water Depth at Source " },
  {"WatDepthGrp",    SAVE_LONG_DEF,  16,  1, " Water Depth at Group " },
  {"ElevScaler",     SAVE_SHORT_DEF, 34,  1, " Elevation Scaler " },
  {"XYScaler",       SAVE_SHORT_DEF, 35,  1, " Coordinate Scaler " },
  {"SrcX",           SAVE_LONG_DEF,  18,  1, " Source Coordinate - X " },
  {"SrcY",           SAVE_LONG_DEF,  19,  1, " Source Coordinate - Y " },
  {"GrpX",           SAVE_LONG_DEF,  20,  1, " Group Coordinate - X " },
  {"GrpY",           SAVE_LONG_DEF,  21,  1, " Group Coordinate - Y " },
  {"XYUnits",        SAVE_SHORT_DEF, 44,  1, " Coordinate Units " },
  {"WeathVel",       SAVE_SHORT_DEF, 45,  1, " Weathering Velocity " },
  {"SubWeathVel",    SAVE_SHORT_DEF, 46,  1, " Subweathering Velocity " },
  {"UpholeTmSrc",    SAVE_SHORT_DEF, 47,  1, " Uphole Time at Source " },
  {"UpholeTmGrp",    SAVE_SHORT_DEF, 48,  1, " Uphole Time at Group " },
  {"SrcStatic",      SAVE_SHORT_DEF, 49,  1, " Source Static Correction " },
  {"GrpStatic",      SAVE_SHORT_DEF, 50,  1, " Group Static Correction " },
  {"TotalStatic",    SAVE_SHORT_DEF, 51,  1, " Total Static Applied " },
  {"LagTmBreak",     SAVE_SHORT_DEF, 52,  1, " Lag Time A" },
  {"LagTmSrc",       SAVE_SHORT_DEF, 53,  1, " Lag Time B" },
  {"LagTmSmpOne",    SAVE_SHORT_DEF, 54,  1, " Delay Recording Time " },
  {"MuteStart",      SAVE_SHORT_DEF, 55,  1, " Mute Time - Start " },
  {"MuteEnd",        SAVE_SHORT_DEF, 56,  1, " Mute Time - End " },
  {"TrcNumSmp",      SAVE_SHORT_DEF, 57,  1, " Number of Samples in this Trace " },
  {"TrcSmpInt",      SAVE_SHORT_DEF, 58,  1, " Trace Sample Interval in Microsecs" },
  {"GainType",       SAVE_SHORT_DEF, 59,  1, " Gain Type of Field Instruments " },
  {"GainConst",      SAVE_SHORT_DEF, 60,  1, " Instrument Gain Constant " },
  {"GainInit",       SAVE_SHORT_DEF, 61,  1, " Instrument Early or Initial Gain " },
  {"CorrFlag",       SAVE_SHORT_DEF, 62,  1, " Correlated " },
  {"SwpFreqStart",   SAVE_SHORT_DEF, 63,  1, " Sweep Frequency @ Start " },
  {"SwpFreqEnd",     SAVE_SHORT_DEF, 64,  1, " Sweep Frequency @ End " },
  {"SwpLength",      SAVE_SHORT_DEF, 65,  1, " Sweep Length " },
  {"SwpType",        SAVE_SHORT_DEF, 66,  1, " Sweep Type " },
  {"SwpTprStart",    SAVE_SHORT_DEF, 67,  1, " Sweep Trace Taper Length @ Start " },
  {"SwpTprEnd",      SAVE_SHORT_DEF, 68,  1, " Sweep Trace Taper Length @ End"},
  {"SwpTprType",     SAVE_SHORT_DEF, 69,  1, " Sweep Taper Type " },
  {"AntiAliasFreq",  SAVE_SHORT_DEF, 70,  1, " Alias Filter Frequency " },
  {"AntiAliasSlope", SAVE_SHORT_DEF, 71,  1, " Alias Filter Slope" },
  {"NotchFreq",      SAVE_SHORT_DEF, 72,  1, " Notch Filter Frequency " },
  {"NotchSlope",     SAVE_SHORT_DEF, 73,  1, " Notch Filter Slope" },
  {"LowCutFreq",     SAVE_SHORT_DEF, 74,  1, " Low Cut Frequency " },
  {"HighCutFreq",    SAVE_SHORT_DEF, 75,  1, " High Cut Frequency " },
  {"LowCutSlope",    SAVE_SHORT_DEF, 76,  1, " Low Cut Slope " },
  {"HighCutSlope",   SAVE_SHORT_DEF, 77,  1, " Hight Cut Slope " },
  {"DateYear",       SAVE_SHORT_DEF, 78,  1, " Year Data Recorded " },
  {"DateDay",        SAVE_SHORT_DEF, 79,  1, " Day of Year " },
  {"DateHour",       SAVE_SHORT_DEF, 80,  1, " Hour of Day (24 hr clock) " },
  {"DateMin",        SAVE_SHORT_DEF, 81,  1, " Minute of Hour " },
  {"DateSec",        SAVE_SHORT_DEF, 82,  1, " Second of Minute " },
  {"DateType",       SAVE_SHORT_DEF, 83,  1, " Time Basis Code " },
  {"TrcWeight",      SAVE_SHORT_DEF, 84,  1, " Trace Weighting Factor " },
  {"RollSwtch1",     SAVE_SHORT_DEF, 85,  1, " Geophone Group Numbr of Roll Switch Position One " },
  {"RollTrace1",     SAVE_SHORT_DEF, 86,  1, " Geophone Group Number of Trace Number One Within Original Field Record " },
  {"RollTraceN",     SAVE_SHORT_DEF, 87,  1, " Geophone Group Number of Last Trace Within Original Field Record " },
  {"RollGapSize",    SAVE_SHORT_DEF, 88,  1, " Gap Size " },
  {"OverTravel",     SAVE_SHORT_DEF, 89,  1, " Overtravel Associated with Taper at Beginning or End of Line" },
  {"SpareI2",        SAVE_SHORT_DEF, 90, 30, " unassigned " },
  {"SpareI4",        SAVE_LONG_DEF,  45, 15, " unassigned " },
  {"SpareF4",        SAVE_FLOAT_DEF, 45, 15, " unassigned " },
  {"SpareF4ibm",     SAVE_FLOAT_DEF, 45, 15, " unassigned " },
  {"SPAREI4",        SAVE_LONG_DEF,  45, 15, " unassigned " },
/* {"data",           SAVE_FLOAT_DEF, 46,  1, " data " }, */
  {(char *)0,		 -1,  -1, -1, " end of list			" }
  } ;
#endif
