/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* Include file <seplib.h>  This file sets up 
 *
 * <stdio.h>
 * <math.h>
 * pi
 * complex and FILE_DESCR typedefs
 *
 * modified 3/26/83  S. Levin - added check for NOHEADER to fake out
 *   input
 * modified 4/1/83 S. Levin & Shuki - added MIN and MAX definitions.
 *		      Added ifndef checks to make sure these weren't
 *		      predefined. Changed complex and FILE_DESCR to
 *		      reduce potential conflict.
 * adapted  4/4/83 S. Levin - separated declarations into separate
 *		      seplib.h file.
 * modified 7/26/83 S. Levin - declared pi static to avoid linkage conflict
 * modified 5/15/84 S. Levin - added and corrected some extern defs.
 * modified 9/14/85 S. Levin - for Convex - convex had cabs and scabs in math.h * modified 9/18/90 D.Nichols - Added prototyped definitions for ansi-C. 
 */

#include <stdio.h>
#include <math.h>
#include <signal.h>

#ifndef pi
static double snftEkd=3.14159265358979323846264338327950288419716939937510;
#define pi snftEkd
#endif

#ifndef __cplusplus  /* C++ has its own complex arithmetic class */

/*typedef struct { float re, im;} complex; */
#ifndef complex
typedef struct { float re, im;} d0u1m2m3y4cmplx;
#define complex d0u1m2m3y4cmplx
#endif

#endif /* __cplusplus */

/* typedef int FILE_DESCR; */
#ifndef FILE_DESCR
#define FILE_DESCR int
#endif

#ifndef MAX
#define MAX(a,b) ( ((a)>(b)) ? (a):(b) )
#endif
#ifndef MIN
#define MIN(a,b) ( ((a)<(b)) ? (a):(b) )
#endif

#if defined(__stdc__ ) || defined(__STDC__) || defined( __cplusplus)

/* use prototyped function definitions for ansi-C and C++ */

#include <time.h>

extern char *alloc(int), *datapath(char*), *get_stdinbuf();

extern int getpar_( char*, char*, ... ), fetch_( char*, char*, ... );
extern int getch_( char *, char*, ... ), hetch_( char *, char*, ... );
extern int putch_( char*, char*, ... ), auxpar( char*, char*, ... );
extern int getpar( char*, char*, ... ), fetch( char*, char*, ... );
extern int getch( char*, char*, ... ), hetch( char*, char*, ... );
extern int putch( char*, char*, ... ), hclose(), auxpar_( char*, char*, ... );
extern int  fetpar_( char*, char*, ... ), fetpar( char*, char*, ... );
extern int hcount(int), hcount_(int*), hclose_();
extern int  puthead(char*, ... );
extern int reed( int, char*, int ), reed_(int*, char*, int* );
extern int rite( int, char*, int ), rite_(int*, char*, int*);
extern int freed( char*, int, int, FILE*), frite( char*, int, int, FILE*); 
extern int modpar(), modpar_(), noheader();
extern int fsize(int), fsize_(int*);
extern int isapipe(int), isatape(int);
extern int fullnm( char*, int ), fullnm_( char*, int* );
extern int findnm( int, char*, int ), findnm_( int*, char*, int* );
extern int file( char*, int ), file_( char*, int* );
extern int doc( char* ), doc_( char* );
extern int snap( char*, int, int, float* ), snap_( char*, int*, int*, float* );
extern int err( char*, ... ), err_( char*, ... );
extern puttitle();

extern FILE *input(), *output(), *head(), *auxin(char*), *auxout(char*);
extern FILE_DESCR input_(), output_(), head_(), auxin_(char*), auxout_(char*);


#ifndef __cplusplus  /* C++ has its own complex arithmetic library */

/* define complex arithmetic and function library */

extern complex cmul(complex,complex), cmult(complex,complex);
extern complex csmul(complex,float), csmult(complex,float);
extern complex cadd(complex,complex);
extern complex csub(complex,complex), cneg(complex);
extern complex ciexp(float), cexp(complex);
extern complex clog(complex), cmplx(float,float);
extern complex conj(complex), conjg(complex);

extern float ccabs(complex), cabs2(complex);
extern complex cinv(complex), cdiv(complex,complex);
extern complex csqrt(complex), cspow(complex,float);
extern complex h01(float), h02(float), h11(float), h12(float);

#endif /* __cplusplus */


#else /* we don't understand prototyped functions */

extern char *alloc(), *datapath(), *get_stdinbuf();
extern int open(), getpar_(), fetch_(), getch_(), hetch_(), putch_(), hclose_();
extern int getpar(), fetch(), getch(), hetch(), putch(), hclose(), auxpar_();
extern int  hcount(), hcount_(), fetpar_(), fetpar(), puthead(), auxpar();
extern int reed(), reed_(), rite(), rite_(), freed(), frite(); 
extern int modpar(), modpar_(), noheader(), fsize(), fsize_();
extern int isapipe(), isatape(), fullnm(), fullnm_(), findnm(), findnm_();
extern file(), file_(), doc (), doc_ (), snap(), snap_(), err(), err_();
extern puttitle();
extern FILE *freopen(), *fdopen(), *input(), *output(), *head(), *auxin(), *auxout();
extern FILE_DESCR input_(), output_(), head_(), auxin_(), auxout_();
extern long lseek(), time();

/* define complex arithmetic and function library */

extern complex cmul(), cmult(), csmul(), csmult(), cadd(), csub(), cneg();
extern complex ciexp(), cexp(), clog(), cmplx(), conj(), conjg();
extern float ccabs(), cabs2();
extern complex cinv(), cdiv(), csqrt(), cspow(), h01(), h02(), h11(), h12();

#endif
