/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef _SizeDefs_h    /* prevents double inclusion */
#define _SizeDefs_h

#include <localsys.h>
#ifndef C_COMMENTS_DISALLOWED
/*
	SZDTHD	- size of trace header on disk in bytes
	SZTRHD	- size of trace header in pipes in bytes
	LNTRHD   - size of trace header in samples
	SZDVHD	- size of vanl analysis header on disk in bytes
	SZVAHD	- size of vanl analysis header in pipes in bytes
	SZSAMP	- size of floating point sample in bytes
	SZSMPM	- maximum number of trace samples
	SZLNHD	- line file size = (SZTRHD + SZSAMP*MAXSMP)/2
	SZSPRD   - size of the spread in channels
	SZSMPD   - size of sample in pipe (in bytes)
	HSTOFF   - byte count at which historical entries in hlh starts
	HLHOFF   - byte count at which hlh starts
	HLHINT   - size in bytes of integer length entries in hlh
	VDVOFF   - byte count at which v-dv pairs start in vanl format data
	SZHFWD   - size in bytes of 1/2 word
*/
#endif
#define SZDTHD 256
#define LNTRHD 128
#define SZDVHD 2112
#define SZSAMP 4
#define SZLNHD 10000
#define SZSMPM 8192

#ifndef CRAYSYSTEM
#define SZTRHD 256
#define SZSMPD 4
#define SZVAHD 2112
#define SZSPRD 500
#define HSTOFF 1004
#define HLHOFF 1000
#define HLHINT 2
#define VDVOFF 64
#define SZHFWD 2

#else
#define SZTRHD 1024
#define SZSMPD 8
#define SZVAHD 4272
#define SZSPRD 500
#define HSTOFF 2592
#define HLHOFF 2576
#define HLHINT 8
#define VDVOFF 176
#define SZHFWD 8
#endif

#endif	/* end of _SizeDefs_h */
