C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
#include <f77/localsys.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
      COMMON/HICORE/BBUF(1030,1030),ITH(64,1030)
      REAL*4 BUF(1030),WBUF(3000)
      INTEGER*2 IBUF(2316),KBUF(2060)
      INTEGER*4 IHEAD(1158)
      INTEGER   ARGIS
      LOGICAL there
      CHARACTER NTAP*100,OTAP*100,NAME*4,CARDIN*100
      DATA NAME /'AMST'/
      EQUIVALENCE (IHEAD(1),IBUF(1)),(IBUF(129),BUF(1))
      EQUIVALENCE (IBUF(129),KBUF(1))
C
      IF (ARGIS('-?').GT.0.OR.ARGIS('-H').GT.0) THEN
          CALL HELP
          CALL CCEXIT (0)
      ENDIF
C
C     SET INPUT AND OUTPUT UNITS
C
#include <f77/open.h>
      IC=30
      IN=8
      IO=9
      IP=LERR
      IPRT=0
      IF (ARGIS('-V').GT.0) IPRT=1
C
C     OPEN THEM UP
C
      CALL ARGSTR ('-N',NTAP,' ',' ')
      CALL ARGSTR ('-O',OTAP,' ',' ')
      IF (NTAP.EQ.' ')THEN
          IN=0
      ELSE
          CALL LBOPEN (IN,NTAP,'r')
      ENDIF
      IF (OTAP.EQ.' ')THEN
          IO=1
      ELSE
          CALL LBOPEN (IO,OTAP,'w')
      ENDIF
      CALL GAMOCO ('                              2-D AMPS
     *               ',1,IP)
      K=0
C
C     PROCESS LINE HEADER
C
      CALL RTAPE (IN,IHEAD,K)
      IF (K.GT.0) GO TO 20
   10 WRITE (IP,1)
      CALL CCEXIT (100)
   20 CALL HLHPRT (IHEAD,K,'AMST',4,IP)
C     CALL NACCT ('AMST',IHEAD,0.0)
      ISI=IHEAD(15)
      SI=ISI
      INSAMP=IHEAD(16)
      IF (INSAMP.GT.1030) GO TO 1000
      INREC=IHEAD (14)
      IF (INREC.GT.1030) GO TO 1010
      IFOR=IBUF(33)
      IF(IFOR.NE.3) GO TO 1030
      INBYT=256+INSAMP*(IFOR+1)
      INMOV=INSAMP*(IFOR+1)
      CALL WRTAPE (IO,IHEAD,K)
C
C     GET PARAMETERS
C
      CALL ARGSTR ('-C',CARDIN,' ',' ')
      IF (CARDIN.EQ.' ') THEN
          CALL ARGI4 ('-m',MODE,0,0)
          CALL ARGI4 ('-f1',MINF,0,0)
          CALL ARGI4 ('-f2',MIDL,0,0)
          CALL ARGI4 ('-f3',MIDH,0,0)
          CALL ARGI4 ('-f4',MAXF,0,0)
      ELSE
C
C         GET CARD
C
          inquire (file=cardin,exist=there)
          IF (.not.there) then
              WRITE (IP,26) CARDIN
              WRITE (LER,26) CARDIN
              CALL CCEXIT (57)
          ENDIF
          open(unit=IC,file=CARDIN,status='old',form='formatted',
     *access='sequential')
          READ (IC,11,END=30) MODE,MINF,MIDL,MIDH,MAXF
          CLOSE (IC)
      ENDIF
      WRITE (IP,9) MODE,MINF,MIDL,MIDH,MAXF
      CALL CARD (MINF,MIDL,MIDH,MAXF,IP)
      M4=4*INSAMP
      M8=8*INSAMP
C
C     LETS GO FOR THE DATA
C
      N=0
      MVHD=256
      IFR=0
      LRI=0
      ITR=-99
      NN=0
      LNG=1024
      LNG2=(LNG/2)+1
      LNGC=LNG+2
      J=1
C
C     LET'S GET AFTER IT
C
   50 K=0
      CALL RTAPE (IN,IBUF,K)
      IF (K.EQ.0) GO TO 80
      IF (IBUF(106).EQ.ITR) GO TO 60
      IF (IBUF(107).NE.1) GO TO 70
      IF (ITR.EQ.-99) THEN
          IFR=IBUF(106)
          ITR=IBUF(106)
      ELSE
          N= IBUF(106)-1
          WRITE (IP,2) ITR,N
          ITR=IBUF(106)
      ENDIF
   60 ITR=ITR+1
      LRI=IBUF(106)
   70 IF (IBUF(125).EQ.30000) CALL MOVE (0,BUF(1),0,INMOV)
      CALL MOVE (1,ITH(1,J),IBUF(1), MVHD)
      CALL MOVE (1,BBUF(1,J),BUF(1), INMOV)
      J=J+1
      NN=NN+1
      IF (J.EQ.1031) GO TO 1010
      GO TO 50
   80 JEND=J-1
      JFIN=JEND-LWH
      WRITE (IP,7) IFR,LRI
C
C     TIMEWISE FFT ALONG I
C
      DO 90 J=1,JEND
         CALL RFFT (BBUF(1,J),LNG,1)
         CALL RFFTSC (BBUF(1,J),LNG,3,1)
   90 CONTINUE
C
C     SECOND K WISE FFT ALONG J
C
      DO 100 I=1,LNGC,2
         CALL SETUP (WBUF,I,LNG)
         CALL CFFT (WBUF,LNG,1)
         CALL CFFTSC (WBUF,LNG)
         CALL REPL (WBUF,I,LNG)
  100 CONTINUE
C
C     FILTER/SHAPE IT
C
      IF (IPRT.EQ.1) CALL PRNT (IP,'IFLT')
      CALL FILT (MODE,MINF,MIDL,MIDH,MAXF,LNG,LNGC)
      IF (IPRT.EQ.1) CALL PRNT (IP,'OFLT')
      IF (IPRT.EQ.1) CALL PRNT2 (IP,'OFLT')
C
C     K WISE INVERSE FFT ALONG J
C
      DO 200 I=1,LNGC,2
         CALL SETUP (WBUF,I,LNG)
         CALL CFFT (WBUF,LNG,-1)
         CALL REPL (WBUF,I,LNG)
  200 CONTINUE
C
C     SECOND TIMEWISE INVERSE FFT ALONG I
C
      DO 210 J=1,JEND
         CALL RFFTSC (BBUF(1,J),LNG,-3,0)
         CALL RFFT (BBUF(1,J),LNG,-1)
  210 CONTINUE
C
C     WRITE EM OUT
C
      DO 310 J=1,JEND
      CALL MOVE (1,IBUF(1),ITH(1,J),MVHD)
      CALL MOVE (1,BUF(1),BBUF(1,J),INMOV)
      CALL WRTAPE (IO,IBUF,INBYT)
  310 CONTINUE
      CALL LBCLOS (IN)
      CALL LBCLOS (IO)
C     CALL NACCT2 (NN)
      STOP
   30 WRITE (IP,12)
      CALL CCEXIT (100)
 1000 WRITE (IP,5)
      CALL CCEXIT (100)
 1010 WRITE (IP,4)
      CALL CCEXIT (100)
 1020 WRITE (IP,6)
      CALL CCEXIT (100)
 1030 WRITE (IP,8)
      CALL CCEXIT (100)
    1 FORMAT (15X,'ERROR PROCESSING INPUT TAPE HEADER')
    2 FORMAT (10X,'MISSING RECORDS ',I8,' THROUGH',I8)
C   3 FORMAT (//,10X,'*********************************',
C    */,10X,'OUTPUT RECORDS 1 THROUGH ',I8,
C    */,10X,'*********************************')
    4 FORMAT (//,10X,'MORE THAN 1030 RECORDS ON INPUT, STEP LIMITATION')
    5 FORMAT (//,10X,'MORE THAN 1030 SAMPLES ON INPUT, STEP LIMITATION')
    6 FORMAT (//,10X,'WINDOW LENGTH MUST BE LESS THAN 101 POINTS')
    7 FORMAT (/,
     */,10X,'*******************************************************',
     */,10X,'PROCESSED: FIRST RECORD =',I8,' LAST RECORD =',I8,
     */,10X,'*******************************************************')
    8 FORMAT (10X,'INPUT MUST BE FORMAT 3')
    9 FORMAT (//20X,
     *'          1         2         3',
     *'          4         5         6         7         8',
     */21X,
     *'1---*----0----*----0----*----0----*----',
     *'0----*----0----*----0----*----0----*----0',
     */10X,'CARD INPUT ',5I5)
   11 FORMAT (5I5)
   12 FORMAT (//,10X,'NO INPUT CARD, ONE IS REQUIRED')
   26 FORMAT (' FILE',A20,' NOT FOUND')
      END
C
C     !RAMP!
C
      SUBROUTINE RAMP  (A,B,C,D,I,J,K)
      REAL*4 HOLD(1024)
      COMMON/HICORE/BBUF(1030,1030),ITH(64,1030)
      E=A-B
      IF (E.LT.0.0) WRITE (6,1) A,B,C,D,I,J
      RATIO=E/(C-D)
C     WRITE (6,2) RATIO,A,B,C,D,I,J
      AMP=SQRT(BBUF(I,J)**2+BBUF(K,J)**2)
      THETA= ATAN2(BBUF(K,J),BBUF(I,J))
      AMP=RATIO*AMP
      BBUF(I,J)=AMP*COS(THETA)
      BBUF(K,J)=AMP*SIN(THETA)
      RETURN
    1 FORMAT (4x,'#RAMP:',15X,4F15.10,2I6)
C   2 FORMAT (5x,'RAMP:',5F15.10,2I6)
      END
C
C     !AMPST!
C
      SUBROUTINE AMPST (I,J,K)
      COMMON/HICORE/BBUF(1030,1030),ITH(64,1030)
      THETA = ATAN2(BBUF(K,J),BBUF(I,J))
      BBUF(I,J)=1.0*COS(THETA)
      BBUF(K,J)=1.0*SIN(THETA)
      RETURN
      END
C
C     !CARD!
C
      SUBROUTINE CARD (IF1,IF2,IF3,IF4,IP)
      COMMON/HICORE/BBUF(1030,1030),ITH(64,1030)
      IF (IF2.EQ.0) IF2=IF1
      IF (IF3.EQ.0) IF3=IF4
      IF (IF2.EQ.0) GO TO  100
      IF (IF1.EQ.0) IF1=1
      IF (IF1.GT.IF2) GO TO 1010
  100 IF (IF3.GT.IF4) GO TO 1020
      IF (IF3.GT.IF2) GO TO 200
      IF (IF4.EQ.0) GO TO 200
 1000 WRITE (IP,1) IF3,IF2
      CALL CCEXIT (106)
 1010 WRITE (IP,2) IF1,IF2
      CALL CCEXIT (107)
 1020 WRITE (IP,3) IF3,IF4
      CALL CCEXIT (108)
  200 RETURN
    1 FORMAT (/,10X,'IF3 MUST BE > IF2')
    2 FORMAT (/,10X,'IF1 MUST BE < OR = IF2')
    3 FORMAT (/,10X,'IF3 MUST BE < OR = IF4')
      END
C
C     !PRNT!
C
      SUBROUTINE PRNT (IP,M)
      COMMON/HICORE/BBUF(1030,1030),ITH(64,1030)
      REAL*4 AMP (10)
      RETURN
      WRITE (IP,1) M
      DO 10 L=11,70,10
         LL=L+9
         WRITE (IP,3) L,LL
         WRITE (IP,2) (BBUF(1,K),K=L,LL)
         WRITE (IP,2) (BBUF(2,K),K=L,LL)
         I=1
         DO 20 N=L,LL
            AMP(I)=SQRT (BBUF(1,N)**2+BBUF(2,N)**2)
            I=I+1
   20    CONTINUE
         WRITE (IP,2) (AMP(II),II=1,10)
   10 CONTINUE
      RETURN
    1 FORMAT (/,2X,A4)
    2 FORMAT (4X,10F12.5)
    3 FORMAT (3X,2I5)
C
      ENTRY PRNT2 (IP,M)
      RETURN
      WRITE (IP,1) M
      DO 110 L=1,520,10
         LL=L+9
         WRITE (IP,3) L,LL
         WRITE (IP,2) (BBUF(1,K),K=L,LL)
         WRITE (IP,2) (BBUF(2,K),K=L,LL)
         I=1
         DO 120 N=L,LL
            AMP(I)=SQRT (BBUF(1,N)**2+BBUF(2,N)**2)
            I=I+1
  120    CONTINUE
         WRITE (IP,2) (AMP(II),II=1,10)
  110 CONTINUE
      RETURN
      END
C
C     !SETUP!
C
      SUBROUTINE SETUP (WBUF,I,LNG)
      COMMON/HICORE/BBUF(1030,1030),ITH(64,1030)
      REAL*4 WBUF(3000)
      L=I+1
      K=1
      DO 10 J=1,LNG
         WBUF(K)=BBUF(I,J)
         K=K+1
         WBUF(K)=BBUF(L,J)
         K=K+1
   10 CONTINUE
      RETURN
      END
C
C     !REPL!
C
      SUBROUTINE REPL (WBUF,I,LNG)
      COMMON/HICORE/BBUF(1030,1030),ITH(64,1030)
      REAL*4 WBUF(3000)
      L=I+1
      K=1
      DO 10 J=1,LNG
         BBUF(I,J)=WBUF(K)
         K=K+1
         BBUF(L,J)=WBUF(K)
         K=K+1
   10 CONTINUE
      RETURN
      END
C
C     !MINOLY!
C
      SUBROUTINE MINOLY (MIN,LNG,LNGC)
      COMMON/HICORE/BBUF(1030,1030),ITH(64,1030)
      JSTRT=MIN+1
      JSTOP=LNG-MIN
      DO 20 J=JSTART,JSTOP
         DO 10 I=1,LNGC,2
            K=I+1
            CALL AMPST (I,J,K)
   10    CONTINUE
   20 CONTINUE
      JSTRT=JSTRT-1
      ISTRT=1+(2*MIN)
      DO 40 J=1,JSTRT
         DO 30 I=ISTRT,LNGC,2
            K=I+1
            CALL AMPST (I,J,K)
   30    CONTINUE
   40 CONTINUE
      JSTOP=JSTOP+1
      DO 60 J=JSTOP,LNG
         DO 50 I=ISTRT,LNGC,2
            K=I+1
            CALL AMPST (I,J,K)
   50    CONTINUE
   60 CONTINUE
      RETURN
      END
C
C     !FILT!
C
      SUBROUTINE FILT (MODE,MIN,MIDL,MIDH,MAX,LNG,LNGC)
      COMMON/HICORE/BBUF(1030,1030),ITH(64,1030)
      AMAX=MAX
      AMIN=MIN
      AMIDL=MIDL
      AMIDH=MIDH
      IF (MAX.EQ.0) GO TO 75
      MLNGC=4*LNGC
      JSTRT=MAX+1
      JSTOP=LNG-MAX
C
C     LET'S ZERO OUT MIDDLE PART OF SPECTRA
C
      DO 10 J=JSTRT,JSTOP
         CALL MOVE (0,BBUF(1,J),0,MLNGC)
   10 CONTINUE
      CALL PRNT ('F010')
      ISTRT=2*MAX
      IMOV = 4*(LNGC-ISTRT)
      ISTRT=ISTRT+1
      JSTRT=JSTRT-1
C
C     ZERO OUT ALL ABOVE MAX IN WHATS LEFT
C
      DO 20 J=1,JSTRT
         CALL MOVE (0,BBUF(ISTRT,J),0,IMOV)
   20 CONTINUE
      CALL PRNT ('F020')
      JSTOP=JSTOP+1
      DO 30 J=JSTOP,LNG
         CALL MOVE (0,BBUF(ISTRT,J),0,IMOV)
   30 CONTINUE
      CALL PRNT ('F030')
C
C     NOW LET'S HIGH CUT A CIRCLE
C
      MMAX=2*MAX
      DO 50 J=1,MAX
         DO 40 I=1,MMAX,2
            K=I+1
            L=(I+1)/2
            A=J
            B=L
            RAD=SQRT(A**2+B**2)
            IF (RAD.GT.AMAX) THEN
               BBUF(I,J)=0.0
               BBUF(K,J)=0.0
C              IF (I.EQ.1) WRITE (6,1) I,J,RAD,AMAX
C   1 FORMAT (4X,'$F040',2I5,2F15.10)
               GO TO 40
            ENDIF
            IF (MODE.EQ.1.AND.RAD.LE.AMAX) CALL AMPST (I,J,K)
            IF (MIDH.EQ.MAX) GO TO 40
            IF (RAD.GE.AMIDH) CALL RAMP (AMAX,RAD,AMAX,AMIDH,I,J,K)
   40    CONTINUE
   50 CONTINUE
      CALL PRNT ('F050')
      JSTRT=LNG-MAX+1
      DO 70 J=JSTRT,LNG
         DO 60 I=1,MMAX,2
            K=I+1
            L=(I+1)/2
            JJ=LNG-J+1
            A=JJ
            B=L
            RAD=SQRT(A**2+B**2)
            IF (RAD.GT.AMAX) THEN
               BBUF(I,J)=0.0
               BBUF(K,J)=0.0
C              IF (I.EQ.1) WRITE (6,2) I,J,RAD,AMAX
C   2 FORMAT (4X,'$F060',2I5,2F15.10)
               GO TO 60
            ENDIF
            IF (MODE.EQ.1.AND.RAD.LE.AMAX) CALL AMPST (I,J,K)
            IF (MIDH.EQ.MAX) GO TO 60
            IF (RAD.GE.AMIDH) CALL RAMP (AMAX,RAD,AMAX,AMIDH,I,J,K)
   60    CONTINUE
   70 CONTINUE
      CALL PRNT ('F070')
C
C  LETS GET THE LOW CUT CIRCLE NOW
C
   75 IF (MIN.EQ.0) GO TO 140
      IF (MAX.NE.0) GO TO 90
      IF (MODE.EQ.0) GO TO 90
      CALL MINOLY (MIN,LNG,LNGC)
   90 MMIN=2*MIDL
      DO 110 J=1,MIDL
         DO 100 I=1,MMIN,2
            K=I+1
            L=(I+1)/2
            A=J
            B=L
            RAD=SQRT(A**2+B**2)
            IF (RAD.LT.AMIN) THEN
               BBUF(I,J)=0.0
               BBUF(K,J)=0.0
C              IF (I.EQ.1) WRITE (6,3) I,J,RAD,AMIN
C   3 FORMAT (4X,'$F100',2I5,2F15.10)
               GO TO 100
            ENDIF
            IF (MIN.EQ.MIDL) GO TO 100
            IF (RAD.LE.AMIDL) CALL RAMP (RAD,AMIN,AMIDL,AMIN,I,J,K)
  100   CONTINUE
  110 CONTINUE
      CALL PRNT ('F110')
       JSTRT=LNG-MIDL+1
       DO 130 J=JSTRT,LNG
          DO 120 I=1,MMIN,2
             K=I+1
             L=(I+1)/2
             JJ=LNG-J+1
             A=JJ
             B=L
             RAD=SQRT(A**2+B**2)
             IF (RAD.LT.AMIN) THEN
                BBUF(I,J)=0.0
                BBUF(K,J)=0.0
C              IF (I.EQ.1) WRITE (6,4) I,J,RAD,AMIN
C   4 FORMAT (4X,'$F120',2I5,2F15.10)
                GO TO 120
             ENDIF
             IF (MIN.EQ.MIDL) GO TO 120
             IF (RAD.LE.AMIDL) CALL RAMP (RAD,AMIN,AMIDL,AMIN,I,J,K)
  120    CONTINUE
  130 CONTINUE
      CALL PRNT ('F130')
  140 RETURN
       END
C
C  !CCEXIT!
C
      SUBROUTINE CCEXIT (ICODE)
#include <f77/iounit.h>
      IF(ICODE.NE.0) THEN
          WRITE (LERR,1) ICODE
          WRITE (LER,1)  ICODE
      ENDIF
    1 FORMAT (' PROGRAM TERMINATION:  EXIT CODE = 'I6)
      STOP
      END
C
C  !HELP!
C
      SUBROUTINE HELP
#include <f77/iounit.h>
      WRITE (LER,*) ' ************************************************'
      WRITE (LER,*) ' PROGRAM AMST.......SEISMIC SMOOTHING'
      WRITE (LER,*) ' -N {ntap}   :Input seismic data set'
      WRITE (LER,*) ' -O {otap}   :Output seismic data set'
      WRITE (LER,*) ' -m          :Mode'
      WRITE (LER,*) '                  0 = filter'
      WRITE (LER,*) '                  1 = replace'
      WRITE (LER,*) ' -f1         :Filter point one'
      WRITE (LER,*) ' -f2         :Filter point two'
      WRITE (LER,*) ' -f3         :Filter point three'
      WRITE (LER,*) ' -f4         :Filter point four'
      WRITE (LER,*) ' -V          :Verbose print out'
      WRITE (LER,*) ' ************************************************'
      WRITE (LER,*) ' USAGE'
      WRITE (LER,*) ' amst -Nntap -Ootap -m -f1 -f2 -f3 -f4 -V'
      WRITE (LER,*) ' ************************************************'
      RETURN
      END
