C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c******************************************************************
c                                                                 
c     SUBROUTINE - GetAnglematrix       ENTRY POINT - GetAngleMatrix
c                                                               
c     language - FORTRAN 77                                    
c     System(s) - SUN, CRAY2, CRAY-XMP, HP
c     Author - Richard Crider                                
c     Date written - October, 1994 
c                                                          
c                AMOCO PRODUCTION CO. PROPRIETARY
c                 TO BE MAINTAINED IN CONFIDENCE
c                                                        
c     Abstract - Get the matrix of angles as function of time and
c                offset.
c                                                            
c     USAGE                                                 
c                                                          
c          call GetAngleMatrix(ns,vcoef, angles, dx,
c                       ntr, dt,
c                       timvec, vrms, mode emerg,vtmax,
c                       vsrms,vism,vit,ierr, errparms)
c                                                       
c               ns    =  Number of samples per trace.              
c            vcoef    =  RMS velocity coefficients
c             angles  =  Returned angles matrix
c              stak   =  Returned angle staks
c              dx     =  Trace distances
c              ntr    =  Number of traces per record
c             dt      =  sample interval, in seconds.
c           livebf    =  counter buffer for live samples in each stak.
c           timvec    =  Vector containing time (in sec) for each
c                        sample.
c            vrms     =  RMS Velocity vector, 1 value for each
c                        sample.
c            mode     =  Solution type
c                        0 = Straight Ray
c                        1 = curved Ray
c                        2 = Perturbed curved Ray
c           emerg     =  Angle type   
c                        0 = Incident     
c                        1 = Emergence 
c            vtmax    =  Valid last time for velocity vector  
c             ierr    =  Error flag to be returned by crvray(creray)
c          errparms   =  V2,V1,T2,T1, error time for error
c                        returned by crvray(creray)
c            vsrms    =  Smoothed rms function
c            vism     =  Smooth interval velocities
c             vit     =  Inteval velocities from vrms
c                                                      
c     error/return codes - ierr                 
c                          1 = error in crvray 
c                                              
c***************************************************************
      subroutine GetAngleMatrix(ns,vcoef, angles, dx,ntr,dt,timvec,
     :  vrms, mode,emerg,vtmax,vsrms,vism,vit,ierr,errparms)
c                                                            
c       data declarations                                   
      real angles(*), vcoef(*)
      real timvec(*), vrms(*),vsrms(*),vism(*),vit(*)
      real  dx(*),errparms(*)
      integer emerg,ierr
c
      do i=1,ntr
       if(dx(i).eq.0.0)dx(i)=0.0005
      end do
      const = 1.
      iws=1
      iwe=ns
      if(emerg.eq.0)then
c +=================================================+
c |  crvray and creray build the "angles" matrix    |
c +=================================================+
       call crvray(ntr,angles,timvec,dx,vrms,vcoef,
     : dt,ns,mode,vtmax,ierr,errparms,vsrms,vism,vit,const)
      else
       call creray(ntr,angles,timvec,dx,vrms,vcoef,
     : dt,ns,mode,vtmax,ierr,errparms,vsrms,vism,vit,const)
      endif
      return
      end
