C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE RMS2INT (V,T,N,VTMAX,vi)
C ********************************************************************
C |                                                                  |
C |    SUBROUTINE TO COMPUTE INTERVAL VELOCITY FROM RMS              |
C |    VELOCITY USING DIX EQUATION.                                  |
C |                                                                  |
C |    INPUT:                                                        |
C |    V  - R*4 ARRAY - ARRAY OF RMS VELOCITIES.                     |
C |    IS - I*4 CONST - OUTPUT SAMPLE INTERVAL.                      |
C |    N  - I*4 CONST - NUMBER OF RMS VELOCITIES.                    |
C |                                                                  |
C |    OUTPUT:                                                       |
C |    X  - R*4 ARRAY - ARRAY OF INTERVAL VELOCITIES.                |
C |                                                                  |
C ********************************************************************
      DIMENSION V(*),T(*),vi(*)

      vi(1)=v(1)
      DO I=2,N
         T2=T(I)
         T1=T(I-1)
         TDEL=T2-T1
         vi(I)=V(I)*V(I)*T2-V(I-1)*V(I-1)*T1
         vi(I)=vi(I)/TDEL
         if(vi(i).le.0.0)then
*          vi(I)=0.
*          if(t2.ge.vtmax)vi(i)=vi(i-1)
           vi(i)=vi(i-1)
         else
          vi(I)=SQRT(vi(I))
         endif
      end do
      RETURN
      END
