C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE anmo
C
C**********************************************************************C
C
C anmo READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C APPLIES NORMAL MOVEOUT (WITH OPTIONAL STATICS BEFORE),
C AND PRINTS UPDATED LINE HEADER AND REQUIRED RECORDS
C OR TRACES
C
      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/pid.h>
      integer   hbegin
c     parameter (i2fact=8/szsmpd,lenhed=lntrhd/i2fact,hbegin=1-lenhed)
      parameter (ndiv=10000,adiv=ndiv)
      integer vflag,vrs,vre
      integer vst,ved
      integer obytes
      integer slineheader(szsmpm),vlineheader(szsmpm)
      character   name * 4, ntap * 100, otap * 100, vmod *100
      logical verbos, query, stat,remove
      logical top2bot,bot2top
      logical linear          
      integer argis, pipe
      integer irs, ire, ns, ne
      integer nreout, ntrout, minsamp, lenpad, lenpadms
 
      DATA  name/'ANMO'/
      DATA  pipe/3/
C**********************************************************************C
C     get help if necessary
C**********************************************************************C
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query ) then
        call help()
        call exit(0)
      endif
C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>
C**********************************************************************C
C     read command line parameters
C**********************************************************************C
      call cmdln(ntap,otap,vmod,ns,ne,irs,ire,vrs,vre,stat,         
     1           remove,verbos,lenpadms,factor,top2bot,bot2top,linear)
      vst = 1
      ved = 1
c     if ( verbos ) then
         write(LERR,*)' First record to process              =  ',irs
         write(LERR,*)' Last record to process               =  ',ire
         write(LERR,*)' First velocity to use                =  ',vrs
         write(LERR,*)' Last  velocity to use                =  ',vre
         write(LERR,*)' Starting trace number                =  ',ns
         write(LERR,*)' Ending   trace number                =  ',ne
         write(LERR,*)' Remove nmo correction?               =  ',remove
         write(LERR,*)' Apply linear moveout correction?     =  ',linear
         write(LERR,*)' Apply statics before nmo             =  ',stat
         write(LERR,*)' Reconstruct in top-to-bottom direction?   =  ',
     1                  top2bot
         write(LERR,*)' Reconstruct in bottom-to-top direction?   =  ',
     1                  bot2top
         write(LERR,*)' Trace padded in the front by         =  ',
     1                  lenpadms
         write(LERR,*)' NMO correction multiplication factor ',factor
c     end if

C**********************************************************************C
C     open logical i/o units
C     check line header; save key values
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

      if (vmod .ne. ' ') then
          call getln(luvel, vmod, 'r',-1)
      else
          write(LERR,*)'anmo assumed to be running inside IKP'
          call sisfdfit (luvel, pipe)
      endif
      if(luvel .lt. 0)   then
         write(lerr,*)'anmo error: velocity file -v not accessible'
      endif
c_____________________________________________________________________
c     read in input seismic data line header.
c_____________________________________________________________________
      vflag=1
      lbytes=0
      call rtape (luin,slineheader,lbytes)
      if(lbytes .eq. 0) then
         write(LERR,*)'ANMO: no header read on unit ',luin
         write(LERR,*)'FATAL'
         call exit(0)
      endif
      call hlhprt(slineheader,lbytes,name,4,lerr)
      call saver(slineheader,'NumSmp',nsamp,LINEHEADER)
      call saver(slineheader,'SmpInt',nsi,LINEHEADER)
      call saver(slineheader,'NumTrc',ntrc,LINEHEADER)
      call saver(slineheader,'NumRec',nrec,LINEHEADER)
      call saver(slineheader,'Format',iform,LINEHEADER)
      call saver(slineheader, 'UnitSc', unitsc, LINEHEADER)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(slineheader, 'UnitSc', unitsc, LINEHEADER)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('MulSkw',ifmt_MulSkw,l_MulSkw,ln_MulSkw,TRACEHEADER)
 
      lenhed=ITRWRD
      hbegin=1-lenhed

c_____________________________________________________________________
c     read in velocity worktape line header.
c_____________________________________________________________________
      lvbytes=0
      call rtape (luvel,vlineheader,lvbytes)
      if (lvbytes .eq. 0) then
         write(LERR,*)'ANMO: no header read on velocity unit ',luvel
         write(LERR,*)'FATAL'
         call exit(0)
      endif
      call saver(vlineheader,'NumSmp',nsampv,LINEHEADER)
      call saver(vlineheader,'SmpInt',nsiv,LINEHEADER)
      call saver(vlineheader,'NumTrc',ntrcv,LINEHEADER)
      call saver(vlineheader,'NumRec',nrecv,LINEHEADER)
      call saver(vlineheader,'Format',iformv,LINEHEADER)
c
      if(ntrcv .ne. 1) then
         write(lerr,*)
         write(lerr,*) 'velocity data file must have 1 trace/record'
         write(lerr,*) 'check velin run; do a scan of velocity file'
         write(lerr,*) 'FATAL'
         call exit(1666)
      endif
c_____________________________________________________________________
c     vflag=0 single velocity function
c     vflag=1 multiple velocity function
c_____________________________________________________________________
      if (nrecv .le. 1) vflag=0
      dt = real (nsi) * unitsc

c     if(verbos) then
         write(LERR,*)' '
         write(LERR,*)' Values read from input seismic worktape'   
         write(LERR,*)' # of Samples/Trace =  ',nsamp
         write(LERR,*)' Sample Interval    =  ',nsi
         write(LERR,*)' Traces per Record  =  ',ntrc
         write(LERR,*)' Records per Line   =  ',nrec
         write(LERR,*)' Format of Data     =  ',iform
         if (vflag .eq. 0) then
            write(LERR,*)' Single velocity function will be used'
         endif
         if (stat) write(LERR,*)' Apply Internal Statics'
         if (remove)write(LERR,*)' Remove normal moveout'
         write(LERR,*)' Values read from velocity worktape '             
         write(LERR,*)' # of Samples/Trace =  ',nsampv
         write(LERR,*)' Sample Interval    =  ',nsiv
         write(LERR,*)' Traces per Record  =  ',ntrcv
         write(LERR,*)' Records per Line   =  ',nrecv
         write(LERR,*)' Format of Data     =  ',iformv
         write(lerr,*)' input data unit  luin  = ',luin
         write(lerr,*)' output data unit luout = ',luout
         write(lerr,*)' velocity unit    luvel = ',luvel
         write(LERR,*)' '
c     endif
C**********************************************************************C
C     deal with trace padding for forward/reverse nmo
C     compute number output samples/bytes
C     check length of velocity trace
C**********************************************************************C
      lenpad=nint(float(lenpadms)/nsi)
      minsamp=1-lenpad
      nsampin=nsamp
      if(remove)then
         nsampout=nsampin-lenpad
         nsamporig=nsampout
      else
         nsampout=nsampin+lenpad
         nsamporig=nsampin 
      endif
      obytes=(nsampout+lenhed)*szsmpd   
c     if (verbos) then
         write(LERR,*)' '
         write(LERR,*)' lenpad     = ', lenpad
         write(LERR,*)' minsamp    = ', minsamp
         write(LERR,*)' nsampin    = ', nsampin
         write(LERR,*)' nsampout   = ', nsampout
         write(LERR,*)' obytes     = ', obytes
         write(LERR,*)' '
c     endif
c
      if (nsampv .lt. nsamporig) then
          write(lerr,*)'velocity trace(s) too short; contains ',nsampv,
     1                  ' samples'
          write(lerr,*)'orig input data contains ',nsamporig,' samples'
          write(lerr,*)'rerun velin job so that trace at least ',
     1                  nsi*nsamporig,' ms long'
         call exit(2666)
      endif
C**********************************************************************C
C     check default values and set parameters
C**********************************************************************C
      call cmdchk (ns,ne,irs,ire,ntrc,nrec)
      call cmdchk (vst,ved,vrs,vre,ntrcv,nrecv)
c_____________________________________________________________________
c     modify header as needed
c_____________________________________________________________________
      nreout=ire-irs+1
      ntrout=ne-ns+1
      call savew(slineheader,'NumSmp',nsampout,LINEHEADER)
      call savew(slineheader,'NumTrc',ntrout,LINEHEADER)
      call savew(slineheader,'NumRec',nreout,LINEHEADER)
      call savhlh(slineheader,lbytes,lbyout)
c_____________________________________________________________________
c     write out modified line header
c_____________________________________________________________________
      call wrtape(luout,slineheader,lbyout)
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('uin',l_uin,l_free,nsampin+lenhed,lerr)
      call mapmem('uout',l_uout,l_free,nsampout+lenhed,lerr)
      call mapmem('v',l_v,l_free,nsampv+lenhed,lerr)
      call mapmem('slow',l_slow,l_free,nsampv,lerr)
      call mapmem('slow2',l_slow2,l_free,nsampv,lerr)
      call mapmem('t0',l_t0,l_free,nsamporig,lerr)
      call mapmem('t02',l_t02,l_free,nsamporig,lerr)
      call mapmem('tnmo',l_tnmo,l_free,nsamporig,lerr)
      call mapmem('t0irreg',l_t0irreg,l_free,nsamporig,lerr)
      call mapmem('jleft',l_jleft,l_free,nsamporig,lerr)
      call mapmem('jdiv',l_jdiv,l_free,nsamporig,lerr)
      call mapmem('wgt',l_wgt,l_free,8*(ndiv+1),lerr)
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)
         write(lerr,*)'suggested solutions:'
         write(lerr,*)' check line headers of input data!'           
         write(lerr,*)
         write(lerr,*)'program ANMO aborted'
         call exit(3666)
      endif
c_____________________________________________________________________
c     get interpolation weights.
c_____________________________________________________________________
      call getw8(s(l_wgt),ndiv)
c_____________________________________________________________________
c     do the nmo correction.
c_____________________________________________________________________
      call nmosub(s(l_uin),s(l_uin),s(l_uout),s(l_uout), 
     1            s(l_t0),s(l_t02),s(l_tnmo),
     2            s(l_slow),s(l_slow2),s(l_v),dt,
     2            s(l_wgt),s(l_jleft),s(l_jdiv),adiv,ndiv,  
     3            irs,ire,ns,ne,ntrc,obytes,remove,stat,  
     4            minsamp,nsamp,nsampin,nsampout,nsamporig,
     5            vrs,vre,nrecv,vflag,ntrcv,factor,
     6            hbegin,lenhed,lerr,luin,luout,luvel,
     7            s(l_t0irreg),top2bot,bot2top,linear,
     8 ifmt_StaCor,l_StaCor,ln_StaCor,ifmt_DstSgn,l_DstSgn,ln_DstSgn)

c__________________________________________________________________
c     close files
c__________________________________________________________________
      call lbclos(luin)
      call lbclos(luout)
      call lbclos(luvel)
      close(lerr)
c
      call exit(0)
      end
c__________________________________________________________________
c     online help screen
c__________________________________________________________________
      subroutine help
#include <f77/iounit.h>

         write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'Run this program by typing: anmo and the following arguments'
        write(LER,*)' '
         write(LER,*)
     :' -N [ntap]    (stdin)      : Input data file name'
        write(LER,*)
     :' -O [otap]    (stdout)     : Output data file name'
        write(LER,*)
     :' -v [vmod]    (no default) : velocity model file name'
        write(LER,*)' '
        write(LER,*)
     :' -ns[ns]  starting trace            (default = 1)'
        write(LER,*)
     :' -ne[ne]  ending trace              (default = all traces)'
        write(LER,*)
     :' -rs[irs] starting record           (default = 1)'
        write(LER,*)
     :' -re[ire] ending record             (default = all)'
        write(LER,*)
     :' -sv[vrs] starting velocity record  (default = 1)'
        write(LER,*)
     :' -ev[vrs] ending velocity record    (default = last)'
        write(LER,*)
     :' -t[len]  pad the date in the front (default = 0 ms)'
        write(LER,*)
     :' -S     apply trace header statics'
        write(LER,*)
     :' -R     remove normal moveout'
        write(LER,*)
     :' -T     form the inverse moveout operation of multiply   '
        write(LER,*)   
     :'        mapped data from top to bottom '//
     :'        (default = mute such data)'
        write(LER,*)
     :' -B     form the inverse moveout operation of multiply   '
        write(LER,*)   
     :'        mapped data from bottom to top  '//
     :'        (default = mute such data)'
        write(LER,*)
     :' -L     apply linear moveout correction'//
     :        ' (default = hyperbolic) '
        write(LER,*)   
     :'        for multiply mapped data (default = mute such data)'
        write(LER,*)
     :' -V     verbose printout'
        write(LER,*)' '
        write(LER,*)
     :'Usage: anmo -N[ntap] -O[otap] -v[vmod] -ns[] -ne[] -rs[] -re[]'
        write(LER,*)
     :'             -sv[] -ve[] -f[] -t[] [-S -R -T -B -L -V]'
        write(LER,*)
     :'***************************************************************'

      return
      end

C**********************************************************************C
C     get command line parameters
C**********************************************************************C
      subroutine cmdln(ntap,otap,vmod,ns,ne,irs,ire,vrs,vre,stat,
     1                 remove,verbos,lenpadms,factor,
     2                 top2bot,bot2top,linear)
c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     vmod  - C*100  velocity file name
c      ns   - I      start trace
c      ne   - I      stop end trace
c     irs   - I      start record
c     ire   - I      stop end record
c     vrs   - I      start velocity record
c     vre   - I      end velocity record
c    factor - R      stretch nmo function (helps with aliased events)
c   lenpadms- I      length of beginning trace pad
c   top2bot - L      Reconstruct in top to bottom
c   bot2top - L      Reconstruct in bottom to top
c    stat   - L      normalize stacked trace by # live traces
c   remove  - L      remove normal moveout
c    verbos - L      verbose output or not
c-----
      integer     ns,ne,irs,ire,vrs,vre,argis,lenpadms
      real        factor
      character   ntap*(*),otap*(*),vmod*(*)
      logical     stat,remove,verbos,top2bot,bot2top,linear

      call argstr ('-N', ntap, ' ', ' ' )
      call argstr ('-O', otap, ' ', ' ' )
      call argstr ('-v',vmod, ' ', ' ')
      call argi4  ('-ns',ns,0,0)
      call argi4  ('-ne',ne,0,0)
      call argi4  ('-rs',irs,0,0)
      call argi4  ('-re',ire,0,0)
      call argi4  ('-sv',vrs,1,1)
      call argi4  ('-ev',vre,0,0)
      call argi4  ('-t',lenpadms,0,0)
      call argr4  ('-f',factor,1.0,1.0)
      stat       = ( argis ('-S') .gt. 0 )
      top2bot    = ( argis ('-T') .gt. 0 )
      bot2top    = ( argis ('-B') .gt. 0 )
      remove     = ( argis ('-R') .gt. 0 )
      linear     = ( argis ('-L') .gt. 0 )
      verbos     = ( argis ('-V') .gt. 0 )

      return
      end
