C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, xtap, xouttap, ns, ne, irs, ire,
     :     xgraph_SortFlag, ApplicationFlag, StaticWord, nsamp, nsi, 
     :     ntrc, nrec, iform, nreco, ntrco, verbos )

#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrco, nreco, iform
      integer     ns, ne, irs, ire, ntrc, nrec, length 

      character   ntap*(*), otap*(*), xtap*(*), xouttap*(*)
      character   xgraph_SortFlag*(*), ApplicationFlag
      character   StaticWord*(*)

      logical     verbos
 
      write(LERR,*)' '
      write(LERR,*)' Input line header values '
      write(LERR,*) ' # of samples/trace =  ', nsamp
      write(LERR,*) ' sample interval    =  ', nsi
      write(LERR,*) ' traces per record  =  ', ntrc
      write(LERR,*) ' records per line   =  ', nrec
      write(LERR,*) ' format of data     =  ', iform
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name =  ', ntap(1:length)
      else
        write(LERR,*) ' input data set      =  stdin'
      endif
      write(LERR,*)' '
      write(LERR,*)' Out line header values '
      write(LERR,*) ' # of samples/trace =  ', nsamp
      write(LERR,*) ' sample interval    =  ', nsi
      write(LERR,*) ' traces per record  =  ', ntrco
      write(LERR,*) ' records per line   =  ', nreco
      write(LERR,*) ' format of data     =  ', iform
      length = lenth(otap)
      if (length .gt. 0) then
        write(LERR,*) ' output data set name=  ', otap(1:length)
      else
        write(LERR,*) ' output data set      =  stdout'
      endif
      write(LERR,*)' '
      write(LERR,*)' Command Line Entries '
      write(LERR,*)' '
      write(LERR,*)' start trace = ',ns
      write(LERR,*)' end trace = ',ne
      write(LERR,*)' start record = ',irs
      write(LERR,*)' end record = ',ire
      length = lenth(xtap)
      if (length .gt. 0) 
     :  write(LERR,*)' Input Xgraph file name = ',xtap(1:length)
      length = lenth(xouttap)
      if (length .gt. 0) 
     :  write(LERR,*)' Output Xgraph file name = ',xouttap(1:length)

      if ( xgraph_SortFlag .eq. 'G' ) then
         write(LERR,*)' Input Xgraph index is RecInd'
      else
         write(LERR,*)' Input Xgraph index is SrcLoc'
      endif

      if ( ApplicationFlag .eq. 'header' ) then
         write(LERR,*)' Statics put in header only'
      else
         write(LERR,*)' Statics applied to data'
      endif

      if ( verbos ) write(LERR,*)' Verbose printout requested'
 
      return
      end
