C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine PickCount(lupick,npicks,nsegs)

c -----
c
c     Routine to provide information on total number of
c     picks to read from the input structural xsd headerinfo
c     at pick location file.  Doug has a bug in that option
c     at present that negates the use of the loop to pick up
c     Max_Pick below.  I have put in a patch that I will remove
c     once Doug has fixed his bug.
c
c -----

      integer lupick,npicks,nsegs

      real value

      character key*10

      nsegs = 0
      npicks = 0

c -----
c     new header key,value pickfile format 
c
c -----

      DO while(1.eq.1)
            
         read(lupick,'(a10,1x,f17.6)',end=200)key,value

c -----
c
c     retrieve number of segments 
c
c -----

         if (key.EQ.'No_Seg') then
            nsegs = ifix(value)
         endif

c -----
c
c     retrieve max number of picks
c
c -----

c           if (key.EQ.'Max_Pick') then
c              npicks = ifix(value)
c              if(nsegs.ne.0)goto 200
c           endif

c -----
c
c     count picks [when Doug fixes xsd use the commented
c     out code to get at max space required to read picks
c     and delete the following kludge
c
c -----

         if (key.EQ.'Pick') then
            npicks = npicks + 1
         endif

c -----
c
c     handle name of segment to prevent format read error
c
c -----

         if (key.EQ.'Segment') then
            read(lupick,'(a10,1x,a20)',end=200)key,value
         endif



      ENDDO           

 200  continue

c        npicks = npicks * nsegs

      return
      end
