C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ReadLimits(CrossPicks,CrossPickLocation,CrossIndex,
     :     nsegsCross,Lags,nsi,ThisRecNum,verbos,WindowMin,WindowMax)

c -----
c     routine to search for pick limits in cross correlation limits
c     pickfile [supplied by user] and assign limits in milliseconds
c     to WindowMin and WindowMax.  If no picks found for this location
c     skip static determination and assign a ShotStatic of zero.  The
c     flag for this occurance will be WindowMin=WindowMax=0
c -----

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer nsegsCross,Lags,WindowMin,WindowMax,ThisRecNum
      integer CrossIndex(nsegsCross),counter,index,firstIndex,nsi
      real    CrossPicks(2*SZLNHD),CrossPickLocation(2*SZLNHD)
      real    Pick1,Pick2
      real    slope,Pick
      logical verbos

      Pick1 = 0.
      Pick2 = 0.
      counter = 0
      index = 0

c -----
c     determine onset and offset window time for this location
c     Should be two picks only here if cross correlations are windowed.  
c
c     If something other than two picks are encountered the limits will
c     be set to zero so that no shotstatic will be calculated for this
c     trace of the cross correlations.
c -----

      do 1 i = 1,nsegsCross

         do 5 j = 1,CrossIndex(i)

            index = index + 1
            if(j.eq.1)then

               firstIndex = index
               goto 5

            endif

            if((ThisRecNum.ge.nint(CrossPickLocation(firstIndex))).and.
     :           ThisRecNum.le.nint(CrossPickLocation(index)))then

               counter = counter + 1
               if(counter.gt.2)goto 10

               slope = (CrossPicks(index) - CrossPicks(index-1))/
     :            (CrossPickLocation(index)-CrossPickLocation(index-1)) 

               Pick = slope * (float(ThisRecNum) - 
     :            CrossPickLocation(index-1)) + CrossPicks(index-1)

               if(counter.eq.1)then
                  Pick1 = Pick
                  index = index + (CrossIndex(i)-j)
                  goto 1
               endif

               if(counter.eq.2)then 
                  Pick2 = Pick
                  index = index + (CrossIndex(i)-j)
                  goto 1
               endif

            endif

 5       continue

 1    continue

c if counter is less than two then only one pick was present
c and must kill this static

      if(counter.lt.2)then

         WindowMin = 0
         WindowMax = 0
         return

      endif

      goto 20

 10   continue

      if(verbos)then

         write(LERR,*)'SARCS: No Cross Correlation window'
         write(LERR,*)'        supplied for Record[RecNum] ',ThisRecNum
         write(LERR,*)'WARNING'

      endif         

      WindowMax = 0
      WindowMin = 0
      return

 20   continue

c determine window limits relative to zero lag location

      TimeOfFirstSample = 0. - float((Lags -1)*nsi)

      if(Pick1.lt.Pick2)then

         WindowMin = nint(TimeOfFirstSample + Pick1)
         WindowMax = nint(TimeOfFirstSample + Pick2)

      elseif(Pick2.lt.Pick1)then

         WindowMin = nint(TimeOfFirstSample + Pick2)
         WindowMax = nint(TimeOfFirstSample + Pick1)

      elseif(abs(Pick2-Pick1).lt.1.e-30)then

         WindowMin = 0
         WindowMax = 0

      endif

      if(verbos)then

         write(LERR,*)'SARCS: Cross Correlation window, Record ',
     :        ThisRecNum
         write(LERR,*)'StartTime ',WindowMin,' EndTime ',WindowMax
         write(LERR,*)' '

      endif         

      return
      end


               

               






