C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GetDatum (DatumCDP, PickIndex, 
     :     StructurePicks, CDPlocation, npicks, nsegs, 
     :     Datum )

c May 25/95 added logic to use multiple structural reference horizons
c throughout the temporal record.  Each horizon must exist for every 
c DphInd of the reference stack as was the case with a single structural 
c event.  This routine will retrieve the datum value for each of the 
c above horizons.  There will be nseg of them stored in Datum()
c ----------------------------------------------------------------------
c     purpose of this routine is to retrieve from an xsd header file the
c     value at a given index entry.  Assumption here is that there is an
c     entry for every possible value in the attached dataset.  This means
c     the user must have created the file using output a value at 
c     every trace option

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer npicks, nsegs, DatumCDP
      integer PickIndex(4 * nsegs), CDPlocation(2*npicks)

      real StructurePicks(2*npicks)

      integer StartIndex, EndIndex

      real Datum(nsegs)

c make sure something was found for datumCDP

      if ( datumCDP .eq. 0 ) then
         write(LER,*)' '
         write(LER,*)'SARCS: No DphInd value found at minimum offset'
         write(LER,*)'       location.  Check your trace header '
         write(LER,*)'       entries for DphInd and rerun. '
         write(LER,*)' '
         write(LER,*)' FATAL'
         write(LERR,*)' '
         write(LERR,*)'SARCS: No DphInd value found at minimum offset'
         write(LERR,*)'       location.  Check your trace header '
         write(LERR,*)'       entries for DphInd and rerun. '
         write(LERR,*)' '
         write(LERR,*)' FATAL'
         stop
      endif

c retrieve horizon sample values at CDP location

      do 10 i=1,nsegs

         StartIndex = (i-1)*PickIndex(i)+1
         EndIndex = StartIndex + PickIndex(i) - 1

         do j = StartIndex, EndIndex

            if ( CDPlocation(j) .eq. datumCDP ) then
               datum(i) = StructurePicks(j)
               goto 10
            endif
         enddo

c if execution gets to here then no pick was present for the datumCDP
c which is a disaster and means that the header pickfile does not span
c the data correctly for whatever reason.  The user must stop here and
c repick the structural control file from a REAL stack of his data where
c ALL cdps are present.  He must also be SURE to flag the output value
c at every trace in the xsd header value output menu.

         write(LERR,*)'            Cannot find cdp ',datumCDP,' in the'
         write(LERR,*)'            structural header values file.  You'
         write(LERR,*)'            must verify that all cdps in your '
         write(LERR,*)'            data are represented in this file.'
         write(LERR,*)'            See man page for arcsstack'
         write(LERR,*)' FATAL'

         write(LER,*)' ARCSSTACK: Cannot find cdp ',datumCDP,' in the'
         write(LER,*)'            structural header values file.  You'
         write(LER,*)'            must verify that all cdps in your '
         write(LER,*)'            data are represented in this file.'
         write(LER,*)'            See man page for arcsstack'
         write(LER,*)' FATAL'
         stop

 10   continue

c have recovered nseg datum entries...return to calling routine

      return
      end

