C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ReadPicks(lupicks,StructurePicks,CDPlocation,PickIndex,
     :     nsegs, npicks)

c -----
c
c     routine to read structural xsd header value at pick file
c     to retrieve cdp vs horizon time information 
c
c -----

      integer lupicks, nsegs, npicks, npick, count
      integer CDPlocation(npicks), PickIndex(nsegs)
      integer pointer

      real StructurePicks(npicks),value

      character key*10

      nsegs = 0
      npick = 0
      count = 0

      rewind(lupicks)

      DO while(1.eq.1)
            
         read(lupicks,'(a10,1x,f17.6)',end=200)key,value

c -----
c
c     assign npick to last segment
c     advance segment counter
c     reset pick in a segment counter
c
c -----

           if (key.EQ.'Segment') then

              if(nsegs.gt.0)PickIndex(nsegs) = npick
              nsegs=nsegs+1
              npick = 0
              read(lupicks,'(a10,1x,a20)',end=200)key,value

           endif

c -----
c
c     Increment pick counter
c
c -----

           if (key.EQ.'Pick') then
              count=count+1
              npick = npick + 1
           endif

c -----
c
c     get sample value of pick
c
c -----

           if (key.EQ.'Sample') then
              StructurePicks(count)=value
           endif

c -----
c
c     get DphInd location of pick
c
c -----

           if (key.EQ.'DphInd') then
              CDPlocation(count)=ifix(value)
           endif

      ENDDO

 200  continue

c -----
c
c     assign segment number and number of picks to index() for
c     last segment picked
c
c -----

      if(nsegs.gt.0)PickIndex(nsegs) = npick

c sort picks to increasing CDP indices

      pointer = 1

      do i = 1, nsegs
         call hsort2 ( PickIndex(i), CDPlocation(pointer), 
     :        StructurePicks(pointer) )
         pointer = pointer + PickIndex(i)
      enddo

      return
      end




