C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Stack ( Record, Trace, nsamp, ntrc )

      integer nsamp, ntrc
      integer DeadSample

      real Record(nsamp,ntrc), Trace(nsamp), denominator

c initialize variables

      call vclr(Trace,1,nsamp)

      DO KK = 1, nsamp

c reset zero sample counter

         DeadSample = 0

         do i = 1 , ntrc

c stack Trace traces at this sample

            Trace(KK) = Trace(KK) + Record( KK ,i )

c keep trace of number of dead samples at this level
            
            if( abs( Record( KK ,i ) ) .lt.1.e-31 )
     :           DeadSample = DeadSample + 1

         enddo

c normalize stacks by number of live samples

         denominator = float(ntrc - DeadSample)
         if ( denominator .lt. 1.e-30 ) denominator = 1.
         Trace(KK) = Trace(KK) / denominator

      ENDDO

      return
      end
