C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Structure ( ShotHeaders, Record, work, samps, linear, 
     :     nsamp, ntrc, nsi, nsegs, npicks, 
     :     Datum, PickIndex, StructurePicks, CDPlocation, 
     :     ifmt_DphInd, l_DphInd, ln_DphInd,
     :     ifmt_StaCor, l_StaCor, ln_StaCor ) 

c     purpose of this routine is to apply a structural correction
c     to the record based on a user supplied structural estimate pickfile.  
c     The pickfile comes in as an xsd headervalues file with entries for 
c     DphInd and Sample.

#include <f77/lhdrsz.h>
#include <save_defs.h>

c variables passed from calling routine

      integer nsamp, ntrc, npicks, nsegs, nsi
      integer ShotHeaders(2 * ntrc * ITRWRD)
      integer PickIndex(4 * nsegs), CDPlocation(2*npicks)
      integer ifmt_Stacor, l_StaCor, ln_StaCor 
      integer ifmt_DphInd, l_DphInd, ln_DphInd

      real Record(nsamp,ntrc), StructurePicks(2*npicks) 
      real samps(nsamp), work(nsamp), Datum(nsegs)

      logical linear

c local variables

      real Horizon(SZLNHD), MapTrace(SZLNHD)

      integer h_index, start, end
      integer StaCor, DphInd
      integer header(ITRWRD)

c initialize indices

      h_index = 1 - ITRWRD

      DO i = 1, ntrc

         h_index = h_index + ITRWRD

c retrieve trace header and find entries for DphInd and StaCor 

         call vmov (ShotHeaders(h_index),1,header(1),1,ITRWRD)
         call saver2(header,ifmt_DphInd,l_DphInd,ln_DphInd,DphInd,
     :        TRACEHEADER)
         call saver2(header,ifmt_StaCor,l_StaCor,ln_Stacor,StaCor,
     :        TRACEHEADER)

         if ( StaCor .ne. 30000 ) then

c if trace is live then load the Horizon() array for this CDP.  Logic
c here assumes that all traces have a valid DphInd and that all DphInd
c entries are accounted for in the structural header value at pick file
            
            end = 0
            
            do 10 j = 1, nsegs

c redefine start and end search limits in StructurePicks for each segment
c as the search progresses

               start = end + 1
               end = end + PickIndex(j)

               do k = start, end
                  if ( DphInd .eq. CDPlocation(k) ) then
                     Horizon(j) = StructurePicks(k)
                     start = PickIndex(j) + 1
                     goto 10
                  endif
               enddo
 10         continue

c build  stretch/squeeze map for this trace. 

            call SS_map( nsi, nsamp, nsegs, Datum, Horizon, MapTrace )

c apply stretch/squeeze mapping to trace

            call SS_apply( Record(1,i), work, MapTrace, nsamp, 
     :           samps, linear )

         else

            call vclr(Record(1,i), 1, nsamp)

         endif
      ENDDO

      return
      end
