C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine respmap(env,slope,peaktime,nt)
      real       env(0:nt),slope(0:nt-1)
      real       peaktime(0:nt)
c_____________________________________________________________________
c     generate an array used to map response attributes.
c     the 'response' for a range of samples lieing between 2 local
c     minima of the trace's envelope will be defined to be that of 
c     the local maximum.
c_____________________________________________________________________
c     env.............the envelope (amplitude) of the seismic trace.
c     slope...........working array = d(env)/d(samp)
c     maxpeak.........map of each sample to that sample corresponding
c                     to the appropriate peak.
c     nt+1............number of samples.
c_____________________________________________________________________
c     intiailize
c_____________________________________________________________________
      do 10000 jt=0,nt-1
       slope(jt)=env(jt+1)-env(jt)
10000 continue
      jleft=0

c_____________________________________________________________________
c     Some functions will grab the value in the peaktime array, which
c     is time, and use it as an index into an array, plus or minus 1.
c     To avoid accessing array element -1, which is invalid, set time
c     to .6 to start with rather than 0.  This will cause the array
c     indices (which use nint) to be one.
c_____________________________________________________________________
      time=0.6

      do 50000 jt=1,nt-2
       if(slope(jt-1)*slope(jt) .lt. 0.) then
c_____________________________________________________________________
c         a change in slope is detected!
c_____________________________________________________________________
          if(slope(jt-1) .ge. 0.) then
c_____________________________________________________________________
c            the intervening peak has been detected!
c_____________________________________________________________________
             time=tpeak(env,jt)
          else
c_____________________________________________________________________
c            the right hand trough has been found!
c_____________________________________________________________________
             jright=jt
             do 20000 kt=jleft,jright
              peaktime(kt)=time
20000        continue
             jleft=jright
          endif
       endif
50000 continue
c_____________________________________________________________________
c     cleanup.
c_____________________________________________________________________
      jright=nt
      do 60000 kt=jleft,jright
       peaktime(kt)=time
60000 continue
c
      return
      end
