C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine fitvel(tt, c, nc,nsamp, dt, coefs,
     * sig,ch,vtrms,vsrms,vism, vi,jerr)
c ******************************************************************** c
c *   Subroutine to find the velocity function closest to the        * c
c *   current cdp and compute the coefficients.  If the coefficients * c
c *   are "current", it simply returns the coefficients              * c
c *                                                                  * c
c *   INPUT:                                                         * c
c *                                                                  * c
c *      tt    - R*4() -  vector of times for vf , in secs           * c
c *       c    - R*4() -  vector of velocitis                        * c
c *      nc    - I*4   -  number of points in the vf                 * c
c *   nsamp    - I*4   -  Trace length for vf expansion/interpolation* c
c *     dt     - R*4   -  Sample interval in sec.                    * c
c *    sig     - R*4() -  Individual standard deviations             * c
c *     ch     - R*4   -  chisqr constant for polyfit routine        * c
c *                                                                  * c
c *   OUTPUT :                                                       * c
c *                                                                  * c
c *   vtrms    - R*4() -  Trace-length rms velocity  vector          * c
c *   coefs    - R*4() -  RMS Velocity coefficients                  * c
c *   vsrms    - R*4() -  smoothed rms velocity vector               * c
c *   vism     - R*4() -  smoothed interval velocity vector          * c
c *   vi       - R*4() -  "raw" interval velocities                  * c
c *                                                                  * c
c ******************************************************************** c
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
      parameter (npol = 6)
      real tt(*), c(*),coefs(*),sig(*),vtrms(*)
      real vsrms(*),vism(*),vi(*)
      real work1(1), work2(1),work3(1),time(1)
      real wt(1), wv(1),w1(1), w2(1),w3(1)
      real work4(1), work5(1)
      POINTER (pwork1,work1),(pwork2,work2),(pwork3,work3)
      POINTER (pwork4,work4),(pwork5,work5),(ptime,time)
      POINTER (pwt,wt),(pwv,wv)
      POINTER (pw1,w1),(pw2,w2),(pw3,w3)
      REAL ch
      external fpoly,hsort
 
      jerr = 0
      jabort = 0
      iget = (nsamp+500)*ISZBYT
      call galloc(pwork1,iget,jerr,jabort)
      call galloc(pwork2,iget,jerr,jabort)
      call galloc(pwork3,iget,jerr,jabort)
      call galloc(pwork4,iget,jerr,jabort)
      call galloc(pwork5,iget,jerr,jabort)
      call galloc(pwt   ,iget,jerr,jabort)
      call galloc(pwv   ,iget,jerr,jabort)
      call galloc(ptime ,iget,jerr,jabort)
      iget= npol*nsamp*ISZBYT
      call galloc(pw1,iget,jerr,jabort)
      call galloc(pw2,iget,jerr,jabort)
      call galloc(pw3,iget,jerr,jabort)

      if(jerr.ne.0)return

      tmax = (nsamp-1)*dt
      lclr = npol*nsamp
      do i = 1,nsamp
       time(i) = float(i-1)*dt
      end do
      do ii=1,nsamp
        wt(ii)=0.
        wv(ii)=0.
      end do
      do ii=1,nc
       wt(ii)=tt(ii)
       wv(ii)=c(ii)
      end do
      j=nc
      if(nc.lt.nsamp)then
       if(wt(1).gt.dt)call add_first(wt,wv,nc,j,dt)
       if(wt(j).lt.tmax)then
        call add_last(wt,wv,j,k,tmax)
        j=k
       end if
       do i=1,lclr
        w1(i)=0.
        w2(i)=0.
        w3(i)=0.
       end do
       do i=1,npol
        coefs(i)=0.
       end do
       ch =0.
       call brms(wt,wv,j,nsamp,dt,vtrms)
       do i=1,nsamp
        vtrms(i)=c(i)
       end do
       jl = j
       call infill(wt,wv,work4,work5,jl,j)
       call psvfit(work4,work5,sig,j,coefs,npol,w1,w2,w3,j,npol,
     : ch,fpoly)
       call polev(time,nsamp,coefs,npol,vsrms)
       call rmsint(vsrms,time,nsamp,vism)
       call rmsint(vtrms,time,nsamp,vi)
      else
       do i=1,nsamp
        vtrms(i)=c(i)
       end do
       call psvfit(time,vtrms,sig,j,coefs,npol,w1,w2,w3,j,npol,
     :  ch,fpoly)
       call polev(time,nsamp,coefs,npol,vsrms)
       call rmsint(vsrms,time,nsamp,vism)
       call rmsint(vtrms,time,nsamp,vi)
      endif
       
      call gfree(pw1)
      call gfree(pw2)
      call gfree(pw3)
      call gfree(pwork1)
      call gfree(pwork2)
      call gfree(pwork3)
      call gfree(pwork4)
      call gfree(pwork5)
      call gfree(ptime)
      call gfree(pwt)
      call gfree(pwv)
      return
      END
      subroutine polev(x,nx, co,nco,y)
      real x(*), co(*), y(*)
 
      do 200 i=1,nx
        y(i)=0.
        do 100 j=1,nco
          k = j-1
          y(i)=y(i)+(x(i)+.000001)**k*co(j) 
  100   continue
  200 continue
      return
      end
      subroutine infill(a,b,x,y,la,lx)
      real a(*),b(*),x(*),y(*)
      integer la,lx

      lx = 1
      x(1)=a(1)
      y(1)=b(1)
      do i=2,la
        dx=a(i)-a(i-1)
        if(dx.gt.1.0)then
          dv=abs(b(i)-b(i-1))
          slope=dv/dx
          lx=lx+1
          x(lx)=a(i-1)+1.
          y(lx)=b(i-1)+slope
          lx=lx+1
          y(lx)=b(i)
          x(lx)=a(i)
        else
          lx=lx+1
          x(lx)=a(i)
          y(lx)=b(i)
        endif
      end do
      return
      end
      subroutine add_first(t,v,n,j,dt)
      real t(*),v(*),dt
      integer n,j

      do i=n,1,-1
       t(i+1)=t(i)
       v(i+1)=v(i)
      end do
      t(1)=dt
      v(1)=v(2)-25.
      j=n+1
      return
      end
      subroutine add_last(t,v,n,j,dt)
      real t(*),v(*),dt
      integer n,j

      j = n + 1
      t(j)= dt
      v(j)=v(j-1)+25.
       
      return
      end
      subroutine lineari(x,y,lx,ix,iy,ixi,z)
      real x(*),y(*),z(*)
      integer lx,ix,iy,ixi

      do i=1,lx
       dx=float(iy-ix)
       dy=y(i)-x(i)
       dxx=ixi-ix
       z(i)=x(i)+dy/dx*dxx
      end do
      return
      end
