C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c--------------------------- subroutine anal1 --------------------------
c  this routine does a dft, integration of the spectrum
c  and a linear least squares fit to the integrated spectrum.
      subroutine anal1(u,ug,uavb,amp,cum,gtab,ctab,stab,ntr,nsmp,nfr)

      integer ntr, nfr, nsmp

      real uavb(nsmp,ntr),cum(nfr), res
      real u(nsmp,ntr), amp(nfr), ug(nsmp)
      real ctab(nsmp,nfr), stab(nsmp,nfr), gtab(nsmp)

c--------------------------- compute transform -------------------------
      a11 = real(nfr)
      a12 = 0.0
      a22 = 0.0
      do ifr = 0,nfr-1
         a12 = a12 + real(ifr)
         a22 = a22 + real(ifr)**2
      enddo
      deta = a11*a22 - a12**2

      do itr = 1, ntr
         umin = u(1,itr)
         umax = u(1,itr)
         do ismp = 1,nsmp
            if(u(ismp,itr) .lt. umin)umin = u(ismp,itr)
            if(u(ismp,itr) .gt. umax)umax = u(ismp,itr)
         enddo

         if(umin .ne. umax)then
            do ismp = 1,nsmp
               ug(ismp) = gtab(ismp)*u(ismp,itr)
            enddo
            
            do ifr = 1,nfr
               ur = 0.0
               ui = 0.0
               do ismp = 1, nsmp
                  ur = ur + ug(ismp)*ctab(ismp,ifr)
                  ui = ui + ug(ismp)*stab(ismp,ifr)
               enddo
               amp(ifr) = sqrt(ur**2 + ui**2)
            enddo

            cum(1) = amp(1)

            do ifr = 2,nfr
               cum(ifr) = cum(ifr-1) + amp(ifr)
            enddo
            
            y1 = 0.0
            y2 = 0.0

            do ifr = 0,nfr-1
               y1 = y1 + cum(ifr+1)
               y2 = y2 + real(ifr)*cum(ifr+1)
            enddo

            a0 = (y1*a22 - y2*a12)/deta
            a1 = (y2*a11 - y1*a12)/deta

            res = 0.0

            do ifr = 0,nfr-1
               func = a0 + real(ifr)*a1 
               res = res + ( func - cum(ifr+1) )**2
            enddo

            uavb(1,itr) = a0
            uavb(2,itr) = a1
            uavb(3,itr) = res

         else
            uavb(1,itr) = 0.0
            uavb(2,itr) = 0.0
            uavb(3,itr) = 0.0
         endif
      enddo

      return
      end
