C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------

c     Program Changes:

c      - original written: Adam Gersztenkorn, Dec 97

c     Program Description:

c
c      - routine to calculate coefficients of fit to spectra to calculate
c        spectral amplitude variations with bandwidth

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsampo, nsi, ntrc, nrec, nreco, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ist, iend, irs, ire, argis

      real        unitsc

      character   ntap*255, otap*255, name*3

      logical     verbos

c Program Specific _ dynamic memory variables

      integer RecordSize, HeaderSize, TableSize
      integer errcd1, errcd2, errcd3, errcd4, errcd5, errcd6
      integer errcd7, errcd8, errcd9, errcd10, abort
      integer Headers

      real    u, uavb, cum, amp, fas, ug, gtab, ctab, stab

      pointer (memadr_Headers, Headers(1))
      pointer (memadr_u, u(1))
      pointer (memadr_uavb, uavb(1))
      pointer (memadr_cum, cum(1))
      pointer (memadr_amp, amp(1))
      pointer (memadr_fas, fas(1))
      pointer (memadr_ug, ug(1))
      pointer (memadr_gtab, gtab(1))
      pointer (memadr_ctab, ctab(1))
      pointer (memadr_stab, stab(1))

c Program Specific _ static memory variables

      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      integer nfr, Play_nsampo

      integer hdr_index, tr_index, JJ, KK

      real tcnt, dt, f1, df, scal

      logical Linear, Quadratic, Play, ssam

c Initialize variables

      data abort/0/
      data name/"AVB"/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, irs, ire, ist, iend, f1, df, nfr, 
     :     name, Linear, Quadratic, Play, Play_nsampo, scal, 
     :     ssam, verbos )

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'AVB: no line header on input file',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)

      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      dt = float(nsi) * unitsc

c calculate window center for gaussian taper and also used for
c reference in sine and cosine tables

      tcnt = float( nsamp / 2  + 1 )

c print HLH to printout file 

      call hlhprt (itr, lbytes, name, 3, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

      nsamp = iend - ist + 1
      nreco = ire - irs + 1
      if ( Linear ) nsampo = 3
      if ( Quadratic ) nsampo = 4

      if ( Play .and. Play_nsampo .gt. 0 ) then
         nsampo = Play_nsampo
      elseif ( Play ) then
         nsampo = nsamp
      endif

c modify line header to reflect actual record configuration output
c NOTE: in this case the trace and sample limits are used to 
c       limit processing only.   All data within the selected record
c       range are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumSmp', nsampo, LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsampo 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c set up pointers to header mnemonic StaCor

      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, nsampo, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, f1, df, nfr, Linear, Quadratic, Play, 
     :     Play_nsampo, scal, verbos )

c dynamic memory allocation:  

      RecordSize = ntrc * nsamp 
      HeaderSize = ntrc * ITRWRD 
      TableSize = nsamp * nfr

      call galloc (memadr_Headers, HeaderSize * SZSMPD, errcd1, abort)
      call galloc (memadr_u, RecordSize * SZSMPD, errcd2, abort)
      call galloc (memadr_uavb, RecordSize * SZSMPD, errcd3, abort)
      call galloc (memadr_cum, nfr * SZSMPD, errcd4, abort)
      call galloc (memadr_amp, nfr * SZSMPD, errcd5, abort)
      call galloc (memadr_fas, nfr * SZSMPD, errcd6, abort)
      call galloc (memadr_ug, nsamp * SZSMPD, errcd7, abort)
      call galloc (memadr_gtab, nsamp * SZSMPD, errcd8, abort)
      call galloc (memadr_ctab, TableSize * SZSMPD, errcd9, abort)
      call galloc (memadr_stab, TableSize * SZSMPD, errcd10, abort)
    
      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 .or.
     :     errcd7 .ne. 0 .or.
     :     errcd8 .ne. 0 .or.
     :     errcd9 .ne. 0 .or.
     :     errcd10 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) HeaderSize * SZSMPD, '  bytes'
         write(LERR,*) 2 * RecordSize * SZSMPD, '  bytes'
         write(LERR,*) 4 * nfr * SZSMPD, '  bytes'
         write(LERR,*) 2 * nsamp * SZSMPD, '  bytes'
         write(LERR,*) 2 * TableSize * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) HeaderSize * SZSMPD, '  bytes'
         write(LER,*) 2 * RecordSize * SZSMPD, '  bytes'
         write(LER,*) 4 * nfr * SZSMPD, '  bytes'
         write(LER,*) 2 * nsamp * SZSMPD, '  bytes'
         write(LER,*) 2 * TableSize * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) HeaderSize * SZSMPD, '  bytes'
         write(LERR,*) 2 * RecordSize * SZSMPD, '  bytes'
         write(LERR,*) 4 * nfr * SZSMPD, '  bytes'
         write(LERR,*) 2 * nsamp * SZSMPD, '  bytes'
         write(LERR,*) 2 * TableSize * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         

      do i = 1, HeaderSize
         Headers(i) = 0
      enddo

      call vclr ( u, 1, RecordSize )
      call vclr ( uavb, 1, RecordSize )
      call vclr ( cum, 1, nfr )
      call vclr ( amp, 1, nfr )
      call vclr ( fas, 1, nfr )
      call vclr ( ug, 1, nsamp )
      call vclr ( gtab, 1, nsamp )
      call vclr ( ctab, 1, TableSize )
      call vclr ( stab, 1, TableSize )

c precompute gaussian

      call gtf ( gtab, nsamp, tcnt, scal )

c precompute sine and cosine transform tables

      call cstab ( ctab, stab, nsamp, nfr, dt, tcnt, f1, df )

c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire

      if ( ssam ) 
     :        write(ler,*)' start, current, end ',irs, JJ, ire

c load record to memory

         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD

          DO KK = 1, ntrc

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c set array load points for this trace 

           tr_index = tr_index + nsamp
           hdr_index = hdr_index + ITRWRD

c process only live traces and zero out dead traces

           call saver2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :          TRACEHEADER )

           if ( StaCor .ne. 30000 ) then

c load trace to array Record[]

              call vmov ( itr(ITHWP1 + ist - 1), 1, u(tr_index), 1, 
     :             nsamp )

           else
              call vclr ( u(tr_index), 1, nsamp )
           endif

c load trace header to array Headers[]

           call vmov ( itr, 1, Headers(hdr_index), 1, ITRWRD )

         ENDDO

c Put your subroutine here [remember to declare any arguments you need
c over and above those already declared]

c analize record

         if ( Linear ) then
            call anal1 ( u, ug, uavb, amp, cum, gtab, ctab, stab, 
     :           ntrc, nsamp, nfr )
         elseif ( Quadratic ) then
            call anal2 ( u, ug, uavb, amp, cum, gtab, ctab, stab, 
     :           ntrc, nsamp, nfr )
         elseif ( Play ) then
            call anal3 ( u, ug, uavb, amp, cum, gtab, ctab, stab, 
     :           ntrc, nsamp, nfr )
         endif

c reset array load points for this trace 

         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD

c write output data

         DO KK = 1, ntrc

            tr_index = tr_index + nsamp
            hdr_index = hdr_index + ITRWRD

            call vmov ( uavb(tr_index), 1, itr(ITHWP1), 1, nsampo )
            call vmov ( Headers(hdr_index), 1, itr(1), 1, ITRWRD )
            call wrtape (luout, itr, obytes)
 
         ENDDO

         if ( verbos ) write(lerr,*)' Finished Record ', JJ

      ENDDO

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'avb: Normal Termination'
      write(LER,*)'avb: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'avb: ABNORMAL Termination'
      write(LER,*)'avb: ABNORMAL Termination'
      stop
      end
