C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c--------------------------- subroutine cstab --------------------------
c  this subroutine builds sine and cosine tables for dft.
c  fin is initial frequency and dfr is increment in frequency.
      subroutine cstab(ctab,stab,nsmp,nfr,dt,tc, fin, dfr )
      parameter (pi2 = 2.0*3.141592654)
      real ctab(nsmp,nfr), stab(nsmp,nfr), fin, dfr

c--------------------------- zero out arrays ---------------------------
        do ifr = 1,nfr
          do is = 1,nsmp
          ctab(is,ifr) = 0.0
          stab(is,ifr) = 0.0
          enddo
        enddo

c--------------------------- create tables -----------------------------
        do ifr = 1,nfr
        frad = pi2*(real(ifr-1)*dfr + fin)
          do ismp = 1,nsmp
          wt = frad*(real(ismp) - tc)*dt
          ctab(ismp,ifr) = +cos(wt)
          stab(ismp,ifr) = -sin(wt)
          enddo
        enddo
      return
      end
c-----------------------------------------------------------------------
