C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C
      SUBROUTINE ALEN(A,NPT)
C
C  JH BODINE 9/2/81
C
C  Routine to set analytic signal envelope lobes to value of
C  the time -1.0 of the envelope lobes.
C  The value of the envelope is set from trough
C  to trough. The resulting "Envelope" may be considered to
C  represent a modification of
C     A = Complex envelope
C   NPT = Number of sample points
C
C  Program assumes the first point in the signal is a trough
C  and the first maxima is a peak. If the first maxima is a trough,
C  it will be skipped (STATEMENT #50).
C
      DIMENSION A(1),ITRF(4096)
C
      JT = 1
      JP = 1
      SLOP = 0.
C
C Find array positions of maxima and minima.
C
      NPT1 = NPT - 1
      DO 20  I = 2,NPT1
         SLAST = SLOP
         SLOP = A(I+1) - A(I)
         CHNG = SLAST * SLOP
         IF(CHNG.GE.0.) GO TO 20
         IF(CHNG.LT.0. .AND. SLAST.LT.0.) GO TO 10
         JP = JP+1
         GO TO 20
C
   10    CONTINUE
         IF(JP.EQ.1) GO TO 20
         ITRF(JT) = I
         JT = JT+1
   20 CONTINUE
C
      ITRF(JT)=NPT
      JP = JP-1
      IF(JP.EQ.0) JP=1
C
C Set envelope lobes to value of envelope lobe -1.0
C
      J = 1
      ISTRT = 1
   30 IEND = ITRF(J)
      VALUE = IEND - ISTRT
      DO 40  I = ISTRT,IEND
         A(I) = VALUE
   40 CONTINUE
C
      J = J+1
      IF(IEND.EQ.NPT) GO TO 50
      ISTRT = IEND
      GO TO 30
C
   50 CONTINUE
C
      RETURN
      END
