C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE FILT1D(ARRAYN,ARRAYO,POINTS,DELTAT,F,ANGLE,WEIGHT,
     :                  TYPE,Q,lerr)
      REAL      ARRAYN(*),ARRAYO(*),DELTAT,F(4),ANGLE,Q
      INTEGER   POINTS,WEIGHT,TYPE
      REAL      DATAT(4096),DATAFA(2048),DATAFP(2048)
      REAL      FILTT(4096),FILTFA(2048),FILTFP(2048)
      REAL      SMOOT(4096)
      REAL      FN,DELTAF
      REAL      AVE,TOTAL,DELTAA,ROSST(4096)
      INTEGER   NSAMP,I,J,START,STOP
C
C Find Nyquist frequency, FN
C
      FN = 1.0 / (2.0 * DELTAT)
C
C Find size of the input array
C
      J=1
   10 CONTINUE
      IF(2**J.GE.POINTS)GOTO 20
      IF(2**J.EQ.4096)GOTO 20
      J=J+1
      GOTO 10
   20 CONTINUE
      NSAMP = 2**J
C
C Pad zeros on the input array, if needed
C
      DO 30 I=1,NSAMP
         DATAT(I) = 0.0
   30 CONTINUE
      DO 40 I=1,POINTS
         DATAT((NSAMP-POINTS)/2+I) = ARRAYN(I)
   40 CONTINUE
C
C Find deltaf
C
      DELTAF = FN / FLOAT(NSAMP/2)
C
C Design the operator in the frequency domain
C
      DO 50 I=1,NSAMP/2
          FILTFA(I) = 0.0
          FILTFP(I) = 0.0
   50 CONTINUE
C
C Low cut ramp, if needed
C
      IF(F(2).EQ.0.) GOTO 70
C
      IF(F(1).EQ.0.) THEN
         START = 1
      ELSE
         START = NINT(F(1) / DELTAF)
      ENDIF
C
      IF(F(2).GT.F(1)) THEN
         STOP = NINT(F(2)/DELTAF)
      ELSE
         GOTO 70
      ENDIF
C
      DO 60 I=START,STOP
         FILTFA(I) = FLOAT(I-START)/FLOAT(STOP-START)
   60 CONTINUE
C
   70 CONTINUE
C
C Pass band
C
      IF(F(2).EQ.0.) THEN
         START = 1
      ELSE
         START = NINT(F(2)/DELTAF)
      ENDIF
C
      IF(F(3).EQ.0.) THEN
         STOP = 1
      ELSE
         STOP = NINT(F(3)/DELTAF)
      ENDIF
C
      DO 80 I=START,STOP
         FILTFA(I) = 1.0
   80 CONTINUE
C
C High ramp, if needed
C
      IF(F(3).EQ.0.) THEN
         START = 1
      ELSE
         START = NINT(F(3)/DELTAF)
      ENDIF
C
      IF(F(4).GT.F(3)) THEN
         STOP = NINT(F(4)/DELTAF)
      ELSE
         STOP = START + 1
      ENDIF
C
      DO 90  I=START,STOP
         FILTFA(I) = FLOAT(STOP-I)/FLOAT(STOP-START)
   90 CONTINUE
C
C Build and apply smoothing, if requested
C
      IF(WEIGHT.GT.0) THEN
          IF(TYPE.EQ.0) THEN
C
C     Build Ross operator
C
              DO 100 I=1,NSAMP/2
                   ARG = 1.0-(FLOAT(I-1)/FLOAT(NSAMP/2-1))**2.
                   if(abs(arg).lt.1.0E-10)arg=0.0
                   SMOOT(I) = arg**Q
c                  SMOOT(I) = (1.0-(FLOAT(I-1)/FLOAT(NSAMP/2-1))
c    :                        **2.)**Q
                   SMOOT(NSAMP-I+1) = SMOOT(I)
  100         CONTINUE
         ELSE
C
C Build Bartlett operator
C
              DO 110 I=1,NSAMP/2
                   SMOOT(I)=1.0-FLOAT(I-1)/FLOAT(NSAMP/2-1)
                   SMOOT(NSAMP-I+1) = SMOOT(I)
  110         CONTINUE
         ENDIF
C
C Transform filter operator to time
C
         CALL FFTMCK(FILTT,FILTFA,FILTFP,NSAMP,-1)
C
C Apply smoothing
C
         DO 120 I=1,NSAMP
              FILTT(I) = FILTT(I) * SMOOT(I)
  120    CONTINUE
C
C Transform smoothed operator back to frequency
C
         CALL FFTMCK(FILTT,FILTFA,FILTFP,NSAMP,+1)
      ENDIF
C
C Apply phase shift, if requested
C
      DO 130 I=1,NSAMP/2
         FILTFP(I) = ANGLE
  130 CONTINUE
C
C Remove average value (DC) from data
C
      TOTAL = 0.0
      DO 140 I=1,NSAMP
         TOTAL = TOTAL + DATAT(I)
  140 CONTINUE
      AVE = TOTAL / FLOAT(NSAMP)
      DO 150 I=1,NSAMP
         DATAT(I) = DATAT(I) - AVE
  150 CONTINUE
C
C Transform DATAT to frequency
C
      CALL FFTMCK(DATAT,DATAFA,DATAFP,NSAMP,+1)
C
C Apply filter
C
      DO 160 I=1,NSAMP/2
         DATAFA(I) = DATAFA(I) * FILTFA(I)
         DATAFP(I) = DATAFP(I) + FILTFP(I)
  160 CONTINUE
C
C Transform DATAT back to time
C
      CALL FFTMCK(DATAT,DATAFA,DATAFP,NSAMP,-1)
C
C Replace DC bias if F2=0
C
      IF(F(2).EQ.0.0) THEN
         DO 170 I=I,NSAMP
              DATAT(I) = DATAT(I) + AVE
  170    CONTINUE
      ENDIF
C
C Remove padded zeros from output array, if needed
C
      IF(POINTS.EQ.NSAMP) THEN
         DO 180 I=1,NSAMP
              ARRAYO(I) = DATAT(I)
  180    CONTINUE
      ELSE
         DO 190 I=1,POINTS
              ARRAYO(I) = DATAT(I+(NSAMP-POINTS)/2)
  190    CONTINUE
      ENDIF
C
      RETURN
      END
