      FUNCTION FPEAK (A,K)
C
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FPEAK                                                *
C  ROUTINE TYPE:  FUNCTION  REAL                                       *
C  PURPOSE: ROUTINE TO FIND INFERRED FRACTIONAL ARRAY POSITION         *
C         (TK +/- FRACTION) OF A PEAK OF AN ARRAY.                     *
C  ENTRY POINTS:                                                       *
C      FPEAK  REAL  (A,K)                                              *
C  ARGUMENTS:                                                          *
C      A       REAL         I*  (1) - INPUT ARRAY OF VALUES            *
C      K       INTEGER      O*      - INDEX OF LOCAL MAXIMUM IN A      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   J.H. BODINE                        ORIGIN DATE: 82/10/17  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/10/15  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C      FLOAT   REAL    -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  NONE                                               *
C  GENERAL DESCRIPTION:  LATERAL SYMMETRY ABOUT PEAK IS ASSUMED.       *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      DIMENSION A(1)
C
      TK = FLOAT(K)
      DAL = ABS(A(K)-A(K-1))
      DAH = ABS(A(K)-A(K+1))
C
      TEST = DAL-DAH
      IF(TEST.GT.0.)FPEAK = TK+(1.-DAH/DAL)*.5
      IF(TEST.LT.0.)FPEAK = TK-(1.-DAL/DAH)*.5
      IF(TEST.EQ.0.)FPEAK = TK
C
      RETURN
      END
