C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,fone,ftwo,
     : f3lowr,f4lowr,f3uppr,f4uppr,inorm,iatt,imode,verbos,
     : rflag)
c-----
c     get command arguments
c
c     ntap   - C*100    input file name
c     otap   - C*100    output file name
c     ns     - I*4      starting trace index
c     ne     - I*4      ending trace index
c     irs    - I*4      starting record index
c     ire    - I*4      ending record index
c     fone   - R*4      F1 value of the Ormsby filter
c     ftwo   - R*4      F2 value of the Ormsby filter 
c     f3lowr - R*4      Lower F3 value of the Ormsby filter
c     f4lowr - R*4      Lower F4 value of the Ormsby filter
c     f3uppr - R*4      Upper F3 value of the Ormsby filter
c     f4uppr - R*4      Upper F4 value of the Ormsby filter
c     inorm  - I*4      normalize flag
c     iatt   - I*4      attribute flag
c     imode  - I*4      mode
c     verbos - L        verbose output or not
c     
c-----
      character   ntap*(*), otap*(*)
      integer     ns, ne, irs, ire, inorm, iatt, rflag

      real        fone,ftwo,f3lowr,f4lowr,f3uppr,f4uppr
      logical     verbos, runs
      integer     argis

c-------
c     see manual pages on the argument handler routines
c     for the meanings of these functions
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-ns',ns,    1, 1)
            call argi4 ( '-ne',ne,    0, 0)
            call argi4 ( '-rs',irs,   1, 1)
            call argi4 ( '-re',ire,   0, 0)
            call argr4 ( '-f1', fone,  0., 0.)
            call argr4 ( '-f2', ftwo,  0., 0.) 
            call argr4 ( '-f3L',f3lowr,0., 0.)
            call argr4 ( '-f4L',f4lowr,0., 0.)
            call argr4 ( '-f3U',f3uppr,0., 0.)
            call argr4 ( '-f4U',f4uppr,0., 0.) 
            call argi4 ( '-nr',inorm, 1, 1)
            call argi4 ( '-at',iatt,  0, 0)
            call argi4 ( '-im',imode, 1, 1)
            runs   =   (argis('-F') .gt. 0)
            rflag = 0
            if (runs) rflag = 1
            verbos =   (argis('-V') .gt. 0)

      return
      end
