C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gnavb4u(trace,nsamp,fone,ftwo,f3lowr,f4lowr,f3uppr,
     :                   f4uppr,angle,weight,type,q,nfilt,deltat,
     :                   w0,w0copy,w1,avb,sqlobe,inorm,iatt,
     :                   imode,ierror,foa,fop,scale,runs)
C
C Routine gnavb2u - generates an amplitude versus bandwidth dataset
C                  called avb(nsamp,nfilt), w0(nsamp), w1(nsamp),
C                  and a QC trace, runs(nsamp).
C
C
C Routine by     - r.o. lindsay, m.c. kelly
C                  8 may 1990
C
c Changed dimension order on avb and sqlobe arrays and switched
c subscripts in code where the arrays are used. This makes it 
C possible to use MathAdv routines to speed up execution.  Formerly 
C subroutine genavb2.  Herb Wright, 13 Aug 1992
C
c arguments      - trace  - input trace to be analyzed
c                  nsamp  - number of samples in trace (max = 4096
c                  fone   - f1 value of the ormsby filter.
c                  ftwo   - f2 value of the ormsby filter.
c                  f3lowr - lower f3 value of the ormsby filter.
c                  f4lowr - lower f4 value of the ormsby filter.
c                  f3uppr - upper f3 value of the ormsby filter.
c                  f4uppr - upper f4 value of the ormsby filter.
c                  angle  - ormsby constant phase angle in degrees
c                  weight - 0 = no filter operator smoothing
c                           1 = smooth filter operator
c                  type   - 0 = ross weight
c                           1 = bartlett weight
c                  q      - ross weight exponent
c                  nfilt  - number of filters to apply (max = 50
c                  deltat - sample interval of trace in seconds
c                  w0     - dc intercept of avb with trace polarity.
c                  w0copy - dc intercept of avb, without trace
c                         - polarity. only to be used in the amplitude
c                         - vs bandwidth display in davba.
c                  w1     - slope of avb
c                  avb    - filtered traces
c                  sqlobe - square lobe traces generated from filtered
c                         - traces.
c                  inorm  - 0 = do not normalize avb
c                           1 = normalize wavelet
c                           2 = aaa
c                           3 = aaarms
c                  iatt   - 0 = stack trace
c                           1 = amplitude envelope
c                  imode  - 3 = square value = lobe sum
c                           2 = square value = lobe center value
c                           1 = square value = lobe maximum value
c                           0 = no operation
c                          -1 = spike value = maximum at time = maximum
c                          -2 = spike value = center  at time = center
c                          -3 = spike value = sum     at time = maximum
c                          -4 = spike value = sum     at time = center
c                  ierror - 0 = all ok, clean execution
c                           1 = unknown error occured
C
C Revision to move filter design OUTSIDE of AVB calculation routine.  Lindsay,
C 19 April 1994.
C
C                  foa        = Ormsby filter operator amplitude spectra
C                  fop        = Ormsby filter operator phase spectrum
C                  scale      = Scalars used to normalize AVB
C                  runs       = QC trace whose values range between 0 and 1 
C                               where 1 indicates random errors in fit and
C                               0 indicated systematic errors in fit.
C
C Dimensions.
C
      integer 
     : nsamp,ierror,nfilt,imode,inorm,iatt,j,k,weight,type,
     : icount
C
      integer i
C
C Revision by Lindsay, 25 April 1994.
C Arrays rediminsioned to 4096,10 from 4096,50.
C
      real
     : avb(4096,10), sqlobe(4096,10), f(4),        ftrace(4096), 
     : posneg(4096), quad(4096),      spikes(4096),trace(*), 
     : w0(*),        w0copy(*),       w1(*),        work(4096), 
     : xreg(10),     xtemp(10),       ytemp(10),    angle, 
     : deltat,       df3,             df4,
     : f3lowr,       f3uppr,          f4lowr,       f4uppr, 
     : fn,           fone,            ftwo,         q, 
     : sum 
C
C Revision by Lindsay, 19 April 1994.
C Add dimensions.
C
      real foa(4096,10), fop(4096), scale(*), runs(*)
C
C Preset needed constants
C
      fn = 1.0 / (2.0 * deltat)
      if(nfilt.gt.2) then
          df3 = (f3uppr - f3lowr) / float(nfilt-1)
          df4 = (f4uppr - f4lowr) / float(nfilt-1)
      else
          ierror = 1
          goto 150
      endif
      f(1) = fone
      f(2) = ftwo
C
C start the avb calculations
C     apply filters
C
      do 60 k=1,nfilt
          f(3) = f3lowr + float(k-1) * df3
          f(4) = f4lowr + float(k-1) * df4
          if(f(3).gt.fn) f(3) = fn
          if(f(4).gt.fn) f(4) = fn
C
C Revision by Lindsay, 19 April 1994.
C New filter application routine.
C
C        call filt1d(trace,ftrace,nsamp,deltat,f,angle,weight,type,q)
C
         call ofa1d(trace,ftrace,nsamp,deltat,f,foa(1,k),fop)
C
C Find scaler for aaa if inorm = 2.
C
         if (inorm .eq. 2) then
              sum = 0.0
              do 10  i = 1, nsamp
                   sum = sum + abs(ftrace(i))
   10         continue
              if (sum / float(nsamp) .ne. 0.0) then
                   scale(k) = 307.0 / (sum / float(nsamp))
              else
                   scale(k) = 1.0
              endif
         endif
C
C Find scaler for aaarms if inorm = 3.
C
         if (inorm .eq. 3) then
              sum = 0.0
              do 20  i = 1, nsamp
C
C Revision by Lindsay, 25 April 1994.
C Added abs() function to correct aaarms option.
C
C                  sum = sum + ftrace(i) * ftrace(i)
                   sum = sum + abs(ftrace(i)) ** 2.0
   20         continue
C
C Revision by Lindsay, 25 April 1994.
C sum = ... line moved inside of if loop.
C .ne. changed to .gt.
C
C             sum = (sum / float(nsamp)) ** 0.5
              if(sum.gt.0.0) then
                  sum = (sum / float(nsamp)) ** 0.5
                  scale(k) = 307.0 / (sum / float(nsamp))
              else
                  scale(k) = 1.0
              endif
         endif
C
C Normalize as requested.
C
         if(inorm.gt.0) then
C 
C Revised by Lindsay, 19 April 1994.
C Reinstall "old code" with subscript added to scale.
C
              do 30 j=1,nsamp
                   ftrace(j) = ftrace(j) * scale(k)
   30         continue
         endif
C
C Calculate attribute for calculation of avb, if desired
C
         if(iatt.eq.0) then
C 
C Revised by Lindsay, 25 April 1994.
C Reinstall "old code".
C
              do 40 j=1,nsamp
                   work(j) = ftrace(j)
   40         continue
         else
              call asig(ftrace,quad,deltat,nsamp,icode,work)
         endif
C
C Calculate response if requested.  This routine, lmodea, modifies 
C array work according to array trace.
C
         if(imode.ne.0) then
              call lmodea(trace,work,nsamp,imode)
         endif
C 
C Revised by Lindsay, 25 April 1994.
C Reinstall "old code".
C
         do 50 j=1,nsamp
              avb(j,k) = work(j)
   50    continue
         xreg(k) = (f(3)+f(4)) / 2.0
   60 continue
C
C See if we are dealing with the special case of the amplitude
C envelope.  if so we must work with sample by sample mode rather
C than the tars, square lobe approach used on the other modes.
C
      if (iatt .eq. 1 .or. iatt .eq. 0 .and. imode .eq. 0) then
         do 80 j = 1, nsamp
              icount = 0
              do 70 k = 1, nfilt
c                  yreg(k) = abs(avb(j,k))
                   if (abs(avb(j,k)) .ne. 0.0) then
                        icount = icount + 1
                        ytemp(icount) = abs(avb(j,k))
                        xtemp(icount) = xreg(k)
                   endif
   70         continue
              call linreg(xtemp, ytemp, icount, w1(j), w0(j))
              call gruns(ytemp,w0(j),w1(j),xtemp,runs(j),icount)
              w0copy(j) = w0(j)
   80    continue
         go to 150
      endif
C
C Generate the lobe indicating array from the filtered trace having the
C highest amplitude values.
C
      do 90  i = 1, nsamp
         if (avb(i,nfilt) .lt. 0.0) then
              posneg(i) = -1
         else
              posneg(i) =  1
         endif
   90 continue
C
C Now pass through all the filtered traces first generating a spike
C trace from each and then a square lobe trace for each using the
C above calculated array as a lobe indicator.
C
      do 120 i = 1, nfilt
C 
C Revised by Lindsay, 25 April 1994.
C Reinstall "old code".
C
         do 100 j = 1, nsamp
              work(j) = avb(j,i)
  100    continue
         call mytars(work, spikes, nsamp)
         call sqrtrc(spikes, posneg, work, nsamp)
         do 110 k = 1,nsamp
              sqlobe(k,i) = work(k)
  110    continue
  120 continue
C
C Regress sqlobe on xreg
C
      do 140 j=1,nsamp
          icount = 0
          do 130 k=1,nfilt
              if (abs(sqlobe(j,k)) .ne. 0.0) then
                   icount = icount + 1
                   ytemp(icount) = abs(sqlobe(j,k))
                   xtemp(icount) = xreg(k)
              endif
  130     continue
          call linreg(xtemp, ytemp, icount, w1(j), w0(j))
          call gruns(ytemp,w0(j),w1(j),xtemp,runs(j),icount)
          w0copy(j) = w0(j)
          w0(j) = w0(j) * posneg(j)
  140 continue
C
C Target for time to go home...
C
  150 continue
      return
      end
