C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE MYTARS (TRACE, SPIKES, NSAMPS)
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C AUTHOR: Dennis L. Frampton                    DATE: 12/06/90
C The purpose of this subroutine is to create a spike trace from a
C normal seismic trace.
C INPUT PARAMETERS: TRACE  R*4 - The input trace values.
C                   SPIKES R*4 - The output spikes trace values.
C                   NSAMPS I*4 - The number of samples within the trace.
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      INTEGER NSAMPS, OSIGN, NSIGN
      REAL*4  TRACE(*), SPIKES(*), LOBMAX
C
C Load spikes array with the trace values and work from it.
C
      DO 10 I = 1, NSAMPS
         SPIKES(I) = TRACE(I)
   10 CONTINUE
C
C Capture the value of the first sample and set the sign flag
C accordingly.
C
      LOBMAX = ABS(SPIKES(1))
      IF (SPIKES(1) .LT. 0.0) THEN
         OSIGN = -1
      ELSE
         OSIGN =  1
      ENDIF
C
C Now deal with the remaining samples in the trace.
C
      DO 20 I = 2, NSAMPS
         IF (SPIKES(I) .LT. 0.0) THEN
              NSIGN = -1
         ELSE
              NSIGN =  1
         ENDIF
C
C See if we have switched signs (lobes) or not and deal with
C accordingly.
C
         IF (NSIGN .EQ. OSIGN) THEN
              IF (ABS(SPIKES(I)) .GT. LOBMAX) THEN
                   LOBMAX = ABS(SPIKES(I))
                   SPIKES(I-1) = 0.0
              ELSE
                   SPIKES(I)   = 0.0
              ENDIF
              OSIGN = NSIGN
              GO TO 20
         ELSE
              LOBMAX = ABS(SPIKES(I))
              OSIGN = NSIGN
         ENDIF
   20 CONTINUE
      RETURN
      END
