C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       PKDT                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  TO SET ANALYTIC SIGNAL ENVELOPE LOBES TO VALUE OF         *
C            THE INPUT DATA AT THE POINT WHERE THE ENVELOPE            *
C            IS A MAXIMUM. VALUE OF ENVELOPE SET FROM TROUGH TO TROUGH *
C  ENTRY POINTS:                                                       *
C      PKDT  (DATA,A,NPT)                                              *
C  ARGUMENTS:                                                          *
C      DATA    REAL         I*  (1) - INSTANTANEOUS ATTRIBUTE ARRAY    *
C      A       REAL         U*  (1) - COMPLEX ENVELOPE ON INPUT        *
C                                   - RESPONSE ATTRIBUTE OUTPUT        *
C      NPT     INTEGER      I*      - NUMBER OF SAMPLES IN 'DATA'&'A'  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   J.H. BODINE                        ORIGIN DATE: 81/09/02  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/10/15  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      MNMX - TO FIND RELATIVE MINIMA/RELATIVE MAXIMA OF AMPLITUDE FCN *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  NONE                                               *
C  GENERAL DESCRIPTION:  PROGRAM ASSUMES FIRST POINT IN SIGNAL IS TROUG*
C      AND THE FIRST MAXIMA IS A PEAK. IF THE FIRST MAXIMA IS A TROUGH,*
C      IT WILL BE SKIPPED IN MNMX.                                     *
C  REVISED BY:  J. NORRIS (PKDTA)             REVISION DATE: 83/06/02  *
C       ADD CALL TO MNMX TO SCAN FOR RELATIVE MINIMA/MAXIMA.           *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 90/10/15 ==================   *
C      6  ( OUTPUT SEQUENTIAL ) - DEBUG FILE                           *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE PKDT(DATA,A,NPT)
      DIMENSION A(1),DATA(1),ITRF(4096),IPEAK(4096),PEAK(4096)
C
C Find array positions of maxima and minima. Then set peak values of
C input data at data at IPEAK(I) array positions.
C
      CALL MNMX(A,NPT,IPEAK,JP,ITRF,JT)
C
      DO 10  I=1,JP
         K = IPEAK(I)
         PEAK(I) = DATA(K)
   10 CONTINUE
C
C Set envelope lobes to IPEAK values
C
      J = 1
      ISTRT = 1
   20 IEND = ITRF(J)
      DO 30  I = ISTRT,IEND
         A(I) = PEAK(J)
   30 CONTINUE
C
      J = J+1
      IF(IEND.EQ.NPT) GO TO 40
      ISTRT = IEND
      GO TO 20
C
   40 CONTINUE
      RETURN
      END
