C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       UNWRAP                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C      ROUTINE TESTS FOR CONDITIONS REQUIRING UNWRAPPING OF PHASE      *
C      TO PERMIT INTERPOLATION ACROSS DISCONTINUITIES AT +/-180 DEG.   *
C  ENTRY POINTS:                                                       *
C      UNWRAP  (P)                                                     *
C  ARGUMENTS:                                                          *
C      P       REAL  ??IOU*  (3) -                                     *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   J.H. BODINE                        ORIGIN DATE: 82/10/17  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/10/15  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  NONE                                               *
C  GENERAL DESCRIPTION:  NONE                                          *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 90/10/15 ==================   *
C      P       REAL      U*  (1) - VALUES TO UNWRAP                    *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE UNWRAP(P)
      DIMENSION P(3)
C
      DIS = 0.
C
      DIFL = ABS(P(1)-P(2))
      DIFH = ABS(P(2)-P(3))
C
      IF (DIFL.LT.180..AND.DIFH.LT.180.) RETURN
C
      DO 10 I=1,3
         IF(P(I).LT.0.)P(I) = P(I)+360.
   10 CONTINUE
C
      RETURN
      END
