C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal(ntap,otap,nsamp,nsi,ntrc,nrec,iform,
     :    ns,ne,irs,ire,inorm,iatt,imode,nrout,ntout,
     :    fone,ftwo,f3lowr,f4lowr,f3uppr,f4uppr,lerr,
     :    rflag)
c-----
c     verbose output of processing parameters
c
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c     nsamp - I*4     number of samples in trace
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ns    - I*4     starting trace index
c     ne    - I*4     ending trace index
c     irs   - I*4     starting record index
c     ire   - I*4     ending record index
c     inorm - I*4     normalize flag
c     iatt  - I*4     attribute flag
c     imode - I*4     mode
c     nrout - I*4     number of records written out
c     ntout - I*4     number of traces out/seismic record
c     fone  - R*4     F1 value of the Ormsby filter
c     ftwo  - R*4     F2 value of the Ormsby filter
c     f3lowr- R*4     Lower F3 value of the Ormsby filter
c     f4lowr- R*4     Lower F4 value of the Ormsby filter
c     f3uppr- R*4     Upper F3 value of the Ormsby filter
c     f4uppr- R*4     Upper F4 value of the Ormsby filter
c-----
      integer
     :nsamp,nsi,ntrc,nrec,iform,ns,ne,irs,ire,
     :inorm,iatt,imode,nrout,ntout,rflag
    
      real
     :fone,ftwo,f3lowr,f4lowr,f3uppr,f4uppr

      character   ntap*(*), otap*(*)

      write(lerr,*)' '
      write(lerr,*) ' input data set name =  ', ntap
      write(lerr,*) ' output data set name=  ', otap
      write(lerr,*)' '
      write(lerr,*) ' Input line header values:'
      write(lerr,*) ' # of samples/trace   =  ', nsamp
      write(lerr,*) ' sample interval      =  ', nsi
      write(lerr,*) ' traces per record    =  ', ntrc
      write(lerr,*) ' records per line     =  ', nrec
      write(lerr,*) ' format of data       =  ', iform
      write(lerr,*)' '
      write(lerr,*) ' Command Line prarameters/defaults:'
      write(lerr,*) ' starting trace index = ',ns
      write(lerr,*) ' ending trace index   = ',ne
      write(lerr,*) ' starting record indx = ',irs
      write(lerr,*) ' ending record indx   = ',ire
      write(lerr,*) ' F1                   = ',fone
      write(lerr,*) ' F2                   = ',ftwo
      write(lerr,*) ' Lower F3             = ',f3lowr
      write(lerr,*) ' Lower F4             = ',f4lowr
      write(lerr,*) ' Upper F3             = ',f3uppr
      write(lerr,*) ' Upper F4             = ',f4uppr
      write(lerr,*) ' normalize flag       = ',inorm
      write(lerr,*) ' attribute flag       = ',iatt
      write(lerr,*) ' mode                 = ',imode
      write(lerr,*) ' Standard 3 trc output:'
      write(lerr,*) '   1. max filtered avb'
      write(lerr,*) '   2. omega 0'
      write(lerr,*) '   3. omega 1'
      if (rflag.eq.1) then
        write(lerr,*) ' Add 4th output trace'
        write(lerr,*) '   4. measure of fit bias'
      endif
      write(lerr,*)' '
      write(lerr,*) ' Computed  parameters:'
      write(lerr,*) ' # records out        = ',nrout
      write(lerr,*) ' # traces out/record  = ',ntout
      write(lerr,*)' '
      write(lerr,*)' '

      return
      end
